/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.eventlistener;

import io.prestosql.spi.eventlistener.StageCpuDistribution;
import io.prestosql.spi.eventlistener.StageGcStatistics;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryStatistics {
    private final Duration cpuTime;
    private final Duration wallTime;
    private final Duration queuedTime;
    private final Optional<Duration> waitingTime;
    private final Optional<Duration> analysisTime;
    private final Optional<Duration> executionTime;
    private final long peakUserMemoryBytes;
    private final long peakTotalNonRevocableMemoryBytes;
    private final long peakTaskUserMemory;
    private final long peakTaskTotalMemory;
    private final long physicalInputBytes;
    private final long physicalInputRows;
    private final long internalNetworkBytes;
    private final long internalNetworkRows;
    private final long totalBytes;
    private final long totalRows;
    private final long outputBytes;
    private final long outputRows;
    private final long writtenBytes;
    private final long writtenRows;
    private final double cumulativeMemory;
    private final List<StageGcStatistics> stageGcStatistics;
    private final int completedSplits;
    private final boolean complete;
    private final List<StageCpuDistribution> cpuTimeDistribution;
    private final List<String> operatorSummaries;
    private final Optional<String> planNodeStatsAndCosts;

    public QueryStatistics(Duration cpuTime, Duration wallTime, Duration queuedTime, Optional<Duration> waitingTime, Optional<Duration> analysisTime, Optional<Duration> executionTime, long peakUserMemoryBytes, long peakTotalNonRevocableMemoryBytes, long peakTaskUserMemory, long peakTaskTotalMemory, long physicalInputBytes, long physicalInputRows, long internalNetworkBytes, long internalNetworkRows, long totalBytes, long totalRows, long outputBytes, long outputRows, long writtenBytes, long writtenRows, double cumulativeMemory, List<StageGcStatistics> stageGcStatistics, int completedSplits, boolean complete, List<StageCpuDistribution> cpuTimeDistribution, List<String> operatorSummaries, Optional<String> planNodeStatsAndCosts) {
        this.cpuTime = Objects.requireNonNull(cpuTime, "cpuTime is null");
        this.wallTime = Objects.requireNonNull(wallTime, "wallTime is null");
        this.waitingTime = Objects.requireNonNull(waitingTime, "waitingTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.analysisTime = Objects.requireNonNull(analysisTime, "analysisTime is null");
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        this.peakUserMemoryBytes = peakUserMemoryBytes;
        this.peakTotalNonRevocableMemoryBytes = peakTotalNonRevocableMemoryBytes;
        this.peakTaskUserMemory = peakTaskUserMemory;
        this.peakTaskTotalMemory = peakTaskTotalMemory;
        this.physicalInputBytes = physicalInputBytes;
        this.physicalInputRows = physicalInputRows;
        this.internalNetworkBytes = internalNetworkBytes;
        this.internalNetworkRows = internalNetworkRows;
        this.totalBytes = totalBytes;
        this.totalRows = totalRows;
        this.outputBytes = outputBytes;
        this.outputRows = outputRows;
        this.writtenBytes = writtenBytes;
        this.writtenRows = writtenRows;
        this.cumulativeMemory = cumulativeMemory;
        this.stageGcStatistics = Objects.requireNonNull(stageGcStatistics, "stageGcStatistics is null");
        this.completedSplits = completedSplits;
        this.complete = complete;
        this.cpuTimeDistribution = Objects.requireNonNull(cpuTimeDistribution, "cpuTimeDistribution is null");
        this.operatorSummaries = Objects.requireNonNull(operatorSummaries, "operatorSummaries is null");
        this.planNodeStatsAndCosts = Objects.requireNonNull(planNodeStatsAndCosts, "planNodeStatsAndCosts is null");
    }

    public Duration getCpuTime() {
        return this.cpuTime;
    }

    public Duration getWallTime() {
        return this.wallTime;
    }

    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    public Optional<Duration> getResourceWaitingTime() {
        return this.waitingTime;
    }

    public Optional<Duration> getAnalysisTime() {
        return this.analysisTime;
    }

    public Optional<Duration> getExecutionTime() {
        return this.executionTime;
    }

    public long getPeakUserMemoryBytes() {
        return this.peakUserMemoryBytes;
    }

    public long getPeakTotalNonRevocableMemoryBytes() {
        return this.peakTotalNonRevocableMemoryBytes;
    }

    public long getPeakTaskUserMemory() {
        return this.peakTaskUserMemory;
    }

    public long getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory;
    }

    public long getPhysicalInputBytes() {
        return this.physicalInputBytes;
    }

    public long getPhysicalInputRows() {
        return this.physicalInputRows;
    }

    public long getInternalNetworkBytes() {
        return this.internalNetworkBytes;
    }

    public long getInternalNetworkRows() {
        return this.internalNetworkRows;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public long getOutputBytes() {
        return this.outputBytes;
    }

    public long getOutputRows() {
        return this.outputRows;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public long getWrittenRows() {
        return this.writtenRows;
    }

    public double getCumulativeMemory() {
        return this.cumulativeMemory;
    }

    public List<StageGcStatistics> getStageGcStatistics() {
        return this.stageGcStatistics;
    }

    public int getCompletedSplits() {
        return this.completedSplits;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public List<StageCpuDistribution> getCpuTimeDistribution() {
        return this.cpuTimeDistribution;
    }

    public List<String> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    public Optional<String> getPlanNodeStatsAndCosts() {
        return this.planNodeStatsAndCosts;
    }
}

