/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.util.BitSet;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "Yarn", "Ranger", "Hive", "HBase"})
@InterfaceStability.Evolving
public interface IAccessAuthorizer {
    public boolean checkAccess(IOzoneObj var1, RequestContext var2) throws OMException;

    default public boolean isNative() {
        return false;
    }

    public static enum ACLIdentityType {
        USER("user"),
        GROUP("group"),
        WORLD("world"),
        ANONYMOUS("anonymous"),
        CLIENT_IP("ip");

        private final String value;

        public String toString() {
            return this.value;
        }

        private ACLIdentityType(String val) {
            this.value = val;
        }
    }

    public static enum ACLType {
        READ,
        WRITE,
        CREATE,
        LIST,
        DELETE,
        READ_ACL,
        WRITE_ACL,
        ALL,
        NONE;

        private static int length;
        private static ACLType[] vals;

        public static int getNoOfAcls() {
            return length;
        }

        public static ACLType getAclTypeFromOrdinal(int ordinal) {
            if (ordinal > length - 1 && ordinal > -1) {
                throw new IllegalArgumentException("Ordinal greater than array length. ordinal:" + ordinal);
            }
            return vals[ordinal];
        }

        public static ACLType getACLRight(String type) {
            if (type == null || type.isEmpty()) {
                throw new IllegalArgumentException("ACL right cannot be empty");
            }
            switch (type) {
                case "r": {
                    return READ;
                }
                case "w": {
                    return WRITE;
                }
                case "c": {
                    return CREATE;
                }
                case "d": {
                    return DELETE;
                }
                case "l": {
                    return LIST;
                }
                case "x": {
                    return READ_ACL;
                }
                case "y": {
                    return WRITE_ACL;
                }
                case "a": {
                    return ALL;
                }
                case "n": {
                    return NONE;
                }
            }
            throw new IllegalArgumentException("[" + type + "] ACL right is not recognized");
        }

        public static String getACLString(BitSet acls) {
            StringBuffer sb = new StringBuffer();
            acls.stream().forEach(acl -> sb.append(ACLType.getAclString(ACLType.values()[acl])));
            return sb.toString();
        }

        public static String getAclString(ACLType acl) {
            switch (acl) {
                case READ: {
                    return "r";
                }
                case WRITE: {
                    return "w";
                }
                case CREATE: {
                    return "c";
                }
                case DELETE: {
                    return "d";
                }
                case LIST: {
                    return "l";
                }
                case READ_ACL: {
                    return "x";
                }
                case WRITE_ACL: {
                    return "y";
                }
                case ALL: {
                    return "a";
                }
                case NONE: {
                    return "n";
                }
            }
            throw new IllegalArgumentException("ACL right is not recognized");
        }

        static {
            length = ACLType.values().length;
            vals = ACLType.values();
        }
    }
}

