/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.service.RangerBasePlugin;

class RangerHivePlugin
extends RangerBasePlugin {
    public static boolean URIPermissionCoarseCheck = false;
    public static boolean UpdateXaPoliciesOnGrantRevoke = true;
    public static boolean BlockUpdateIfRowfilterColumnMaskSpecified = true;
    public static String DescribeShowTableAuth = "NONE";
    private static String RANGER_PLUGIN_HIVE_ULRAUTH_FILESYSTEM_SCHEMES = "ranger.plugin.hive.urlauth.filesystem.schemes";
    private static String RANGER_PLUGIN_HIVE_ULRAUTH_FILESYSTEM_SCHEMES_DEFAULT = "hdfs:,file:";
    private static String FILESYSTEM_SCHEMES_SEPARATOR_CHAR = ",";
    private String[] fsScheme = null;

    public RangerHivePlugin(String appType) {
        super("hive", appType);
    }

    public void init() {
        super.init();
        URIPermissionCoarseCheck = this.getConfig().getBoolean("xasecure.hive.uri.permission.coarse.check", false);
        UpdateXaPoliciesOnGrantRevoke = this.getConfig().getBoolean("xasecure.hive.update.xapolicies.on.grant.revoke", true);
        BlockUpdateIfRowfilterColumnMaskSpecified = this.getConfig().getBoolean("xasecure.hive.block.update.if.rowfilter.columnmask.specified", true);
        DescribeShowTableAuth = this.getConfig().get("xasecure.hive.describetable.showcolumns.authorization.option", "NONE");
        String fsSchemesString = this.getConfig().get(RANGER_PLUGIN_HIVE_ULRAUTH_FILESYSTEM_SCHEMES, RANGER_PLUGIN_HIVE_ULRAUTH_FILESYSTEM_SCHEMES_DEFAULT);
        this.fsScheme = StringUtils.split((String)fsSchemesString, (String)FILESYSTEM_SCHEMES_SEPARATOR_CHAR);
        if (this.fsScheme != null) {
            for (int i = 0; i < this.fsScheme.length; ++i) {
                this.fsScheme[i] = this.fsScheme[i].trim();
            }
        }
    }

    public String[] getFSScheme() {
        return this.fsScheme;
    }
}

