/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;

public class OzoneKey {
    private final String volumeName;
    private final String bucketName;
    private final String name;
    private final long dataSize;
    private Instant creationTime;
    private Instant modificationTime;
    private ReplicationConfig replicationConfig;
    private Map<String, String> metadata = new HashMap<String, String>();
    private final boolean isFile;

    public OzoneKey(String volumeName, String bucketName, String keyName, long size, long creationTime, long modificationTime, ReplicationConfig replicationConfig, boolean isFile) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.name = keyName;
        this.dataSize = size;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
        this.replicationConfig = replicationConfig;
        this.isFile = isFile;
    }

    public OzoneKey(String volumeName, String bucketName, String keyName, long size, long creationTime, long modificationTime, ReplicationConfig replicationConfig, Map<String, String> metadata, boolean isFile) {
        this(volumeName, bucketName, keyName, size, creationTime, modificationTime, replicationConfig, isFile);
        this.metadata.putAll(metadata);
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getName() {
        return this.name;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata.putAll(metadata);
    }

    @Deprecated
    @JsonIgnore
    public ReplicationType getReplicationType() {
        return ReplicationType.fromProto((HddsProtos.ReplicationType)this.replicationConfig.getReplicationType());
    }

    @Deprecated
    @JsonIgnore
    public int getReplicationFactor() {
        return this.replicationConfig.getRequiredNodes();
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public static OzoneKey fromKeyInfo(OmKeyInfo keyInfo) {
        return new OzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName(), keyInfo.getDataSize(), keyInfo.getCreationTime(), keyInfo.getModificationTime(), keyInfo.getReplicationConfig(), keyInfo.getMetadata(), keyInfo.isFile());
    }
}

