/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.sql.implementation.ManagedInstanceInner;
import com.microsoft.azure.management.sql.implementation.ManagedInstanceUpdateInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedInstancesInner
implements InnerSupportsGet<ManagedInstanceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ManagedInstanceInner> {
    private ManagedInstancesService service;
    private SqlManagementClientImpl client;

    public ManagedInstancesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedInstancesService)retrofit.create(ManagedInstancesService.class);
        this.client = client;
    }

    public PagedList<ManagedInstanceInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ManagedInstanceInner>((Page)response.body()){

            public Page<ManagedInstanceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstancesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceInner>> listAsync(ListOperationCallback<ManagedInstanceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(String nextPageLink) {
                return ManagedInstancesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceInner>>, Page<ManagedInstanceInner>>(){

            public Page<ManagedInstanceInner> call(ServiceResponse<Page<ManagedInstanceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceInner>>, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(ServiceResponse<Page<ManagedInstanceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstancesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.list(this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstancesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedInstanceInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ManagedInstanceInner>((Page)response.body()){

            public Page<ManagedInstanceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstancesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ManagedInstanceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(String nextPageLink) {
                return ManagedInstancesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceInner>>, Page<ManagedInstanceInner>>(){

            public Page<ManagedInstanceInner> call(ServiceResponse<Page<ManagedInstanceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceInner>>, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(ServiceResponse<Page<ManagedInstanceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstancesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstancesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedInstanceInner getByResourceGroup(String resourceGroupName, String managedInstanceName) {
        return (ManagedInstanceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, managedInstanceName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedInstanceInner> getByResourceGroupAsync(String resourceGroupName, String managedInstanceName, ServiceCallback<ManagedInstanceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, managedInstanceName), serviceCallback);
    }

    public Observable<ManagedInstanceInner> getByResourceGroupAsync(String resourceGroupName, String managedInstanceName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<ManagedInstanceInner>, ManagedInstanceInner>(){

            public ManagedInstanceInner call(ServiceResponse<ManagedInstanceInner> response) {
                return (ManagedInstanceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.getByResourceGroup(resourceGroupName, managedInstanceName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceInner>>>(){

            public Observable<ServiceResponse<ManagedInstanceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstancesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedInstanceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedInstanceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedInstanceInner createOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceInner parameters) {
        return (ManagedInstanceInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedInstanceInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceInner parameters, ServiceCallback<ManagedInstanceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    public Observable<ManagedInstanceInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedInstanceInner>, ManagedInstanceInner>(){

            public ManagedInstanceInner call(ServiceResponse<ManagedInstanceInner> response) {
                return (ManagedInstanceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, managedInstanceName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedInstanceInner>(){}.getType());
    }

    public ManagedInstanceInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceInner parameters) {
        return (ManagedInstanceInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedInstanceInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceInner parameters, ServiceCallback<ManagedInstanceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    public Observable<ManagedInstanceInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedInstanceInner>, ManagedInstanceInner>(){

            public ManagedInstanceInner call(ServiceResponse<ManagedInstanceInner> response) {
                return (ManagedInstanceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2015-05-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceInner>>>(){

            public Observable<ServiceResponse<ManagedInstanceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstancesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedInstanceInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedInstanceInner>(){}.getType()).register(201, new TypeToken<ManagedInstanceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String managedInstanceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String managedInstanceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String managedInstanceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, managedInstanceName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String managedInstanceName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String managedInstanceName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginDelete(resourceGroupName, managedInstanceName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstancesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedInstanceInner update(String resourceGroupName, String managedInstanceName, ManagedInstanceUpdateInner parameters) {
        return (ManagedInstanceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedInstanceInner> updateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceUpdateInner parameters, ServiceCallback<ManagedInstanceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    public Observable<ManagedInstanceInner> updateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceUpdateInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedInstanceInner>, ManagedInstanceInner>(){

            public ManagedInstanceInner call(ServiceResponse<ManagedInstanceInner> response) {
                return (ManagedInstanceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceInner>> updateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceUpdateInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, managedInstanceName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedInstanceInner>(){}.getType());
    }

    public ManagedInstanceInner beginUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceUpdateInner parameters) {
        return (ManagedInstanceInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedInstanceInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceUpdateInner parameters, ServiceCallback<ManagedInstanceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    public Observable<ManagedInstanceInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceUpdateInner parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedInstanceInner>, ManagedInstanceInner>(){

            public ManagedInstanceInner call(ServiceResponse<ManagedInstanceInner> response) {
                return (ManagedInstanceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedInstanceInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceUpdateInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        return this.service.beginUpdate(resourceGroupName, managedInstanceName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceInner>>>(){

            public Observable<ServiceResponse<ManagedInstanceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedInstancesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedInstanceInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedInstanceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedInstanceInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedInstanceInner>((Page)response.body()){

            public Page<ManagedInstanceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstancesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ManagedInstanceInner>> serviceFuture, ListOperationCallback<ManagedInstanceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(String nextPageLink) {
                return ManagedInstancesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceInner>>, Page<ManagedInstanceInner>>(){

            public Page<ManagedInstanceInner> call(ServiceResponse<Page<ManagedInstanceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceInner>>, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(ServiceResponse<Page<ManagedInstanceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstancesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstancesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedInstanceInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedInstanceInner>((Page)response.body()){

            public Page<ManagedInstanceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedInstancesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedInstanceInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ManagedInstanceInner>> serviceFuture, ListOperationCallback<ManagedInstanceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(String nextPageLink) {
                return ManagedInstancesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedInstanceInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedInstanceInner>>, Page<ManagedInstanceInner>>(){

            public Page<ManagedInstanceInner> call(ServiceResponse<Page<ManagedInstanceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedInstanceInner>>, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(ServiceResponse<Page<ManagedInstanceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedInstancesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedInstanceInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedInstanceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedInstancesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedInstanceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedInstancesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Sql/managedInstances")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Body ManagedInstanceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Body ManagedInstanceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Body ManagedInstanceUpdateInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Body ManagedInstanceUpdateInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstances listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

