/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.sql.SqlSyncMember;
import com.microsoft.azure.management.sql.SqlSyncMemberOperations;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlSyncGroupImpl;
import com.microsoft.azure.management.sql.implementation.SqlSyncMemberImpl;
import com.microsoft.azure.management.sql.implementation.SyncMemberInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlSyncMemberOperationsImpl
implements SqlSyncMemberOperations,
SqlSyncMemberOperations.SqlSyncMemberActionsDefinition {
    protected SqlServerManager sqlServerManager;
    protected String resourceGroupName;
    protected String sqlServerName;
    protected String sqlDatabaseName;
    protected String sqlSyncGroupName;
    protected SqlSyncGroupImpl sqlSyncGroup;

    SqlSyncMemberOperationsImpl(SqlSyncGroupImpl parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlSyncGroup = parent;
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        this.sqlDatabaseName = parent.sqlDatabaseName();
        this.sqlSyncGroupName = parent.name();
    }

    SqlSyncMemberOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public SqlSyncMember getBySqlServer(String resourceGroupName, String sqlServerName, String databaseName, String syncGroupName, String name) {
        SyncMemberInner syncMemberInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().get(resourceGroupName, sqlServerName, databaseName, syncGroupName, name);
        return syncMemberInner != null ? new SqlSyncMemberImpl(resourceGroupName, sqlServerName, databaseName, syncGroupName, name, syncMemberInner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlSyncMember> getBySqlServerAsync(final String resourceGroupName, final String sqlServerName, final String databaseName, final String syncGroupName, final String name) {
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().getAsync(resourceGroupName, sqlServerName, databaseName, syncGroupName, name).map((Func1)new Func1<SyncMemberInner, SqlSyncMember>(){

            public SqlSyncMember call(SyncMemberInner syncMemberInner) {
                return new SqlSyncMemberImpl(resourceGroupName, sqlServerName, databaseName, syncGroupName, name, syncMemberInner, SqlSyncMemberOperationsImpl.this.sqlServerManager);
            }
        });
    }

    @Override
    public SqlSyncMember get(String name) {
        if (this.sqlSyncGroup == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlSyncGroup.resourceGroupName(), this.sqlSyncGroup.sqlServerName(), this.sqlSyncGroup.sqlDatabaseName(), this.sqlSyncGroup.name(), name);
    }

    @Override
    public Observable<SqlSyncMember> getAsync(String name) {
        if (this.sqlSyncGroup == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlSyncGroup.resourceGroupName(), this.sqlSyncGroup.sqlServerName(), this.sqlSyncGroup.sqlDatabaseName(), this.sqlSyncGroup.name(), name);
    }

    @Override
    public SqlSyncMember getById(String id) {
        Objects.requireNonNull(id);
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            return this.getBySqlServer(resourceId.resourceGroupName(), resourceId.parent().parent().parent().name(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public Observable<SqlSyncMember> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            return this.getBySqlServerAsync(resourceId.resourceGroupName(), resourceId.parent().parent().parent().name(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public void delete(String name) {
        if (this.sqlSyncGroup == null) {
            return;
        }
        ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().delete(this.sqlSyncGroup.resourceGroupName(), this.sqlSyncGroup.sqlServerName(), this.sqlSyncGroup.sqlDatabaseName(), this.sqlSyncGroup.name(), name);
    }

    @Override
    public Completable deleteAsync(String name) {
        if (this.sqlSyncGroup == null) {
            return null;
        }
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().deleteAsync(this.sqlSyncGroup.resourceGroupName(), this.sqlSyncGroup.sqlServerName(), this.sqlSyncGroup.sqlDatabaseName(), this.sqlSyncGroup.name(), name).toCompletable();
    }

    @Override
    public void deleteById(String id) {
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().delete(resourceId.resourceGroupName(), resourceId.parent().parent().parent().name(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        try {
            ResourceId resourceId = ResourceId.fromString((String)id);
            return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().deleteAsync(resourceId.resourceGroupName(), resourceId.parent().parent().parent().name(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name()).toCompletable();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @Override
    public List<SqlSyncMember> list() {
        PagedList<SyncMemberInner> syncMemberInners;
        ArrayList<SqlSyncMemberImpl> sqlSyncMembers = new ArrayList<SqlSyncMemberImpl>();
        if (this.sqlSyncGroup != null && (syncMemberInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().listBySyncGroup(this.sqlSyncGroup.resourceGroupName(), this.sqlSyncGroup.sqlServerName(), this.sqlSyncGroup.sqlDatabaseName(), this.sqlSyncGroup.name())) != null) {
            for (SyncMemberInner syncMemberInner : syncMemberInners) {
                sqlSyncMembers.add(new SqlSyncMemberImpl(syncMemberInner.name(), this.sqlSyncGroup, syncMemberInner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(sqlSyncMembers);
    }

    @Override
    public Observable<SqlSyncMember> listAsync() {
        final SqlSyncMemberOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).syncMembers().listBySyncGroupAsync(this.sqlSyncGroup.resourceGroupName(), this.sqlSyncGroup.sqlServerName(), this.sqlSyncGroup.sqlDatabaseName(), this.sqlSyncGroup.name()).flatMap((Func1)new Func1<Page<SyncMemberInner>, Observable<SyncMemberInner>>(){

            public Observable<SyncMemberInner> call(Page<SyncMemberInner> syncMemberInnerPage) {
                return Observable.from((Iterable)syncMemberInnerPage.items());
            }
        }).map((Func1)new Func1<SyncMemberInner, SqlSyncMember>(){

            public SqlSyncMember call(SyncMemberInner syncMemberInner) {
                return new SqlSyncMemberImpl(syncMemberInner.name(), self.sqlSyncGroup, syncMemberInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public SqlSyncMemberImpl define(String syncMemberName) {
        SqlSyncMemberImpl result = new SqlSyncMemberImpl(syncMemberName, new SyncMemberInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlSyncGroup != null ? result.withExistingSyncGroup(this.sqlSyncGroup) : result;
    }
}

