/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.MetricAlert;
import com.microsoft.azure.management.monitor.MetricAlertAction;
import com.microsoft.azure.management.monitor.MetricAlertCondition;
import com.microsoft.azure.management.monitor.MetricAlertSingleResourceMultipleMetricCriteria;
import com.microsoft.azure.management.monitor.MetricCriteria;
import com.microsoft.azure.management.monitor.implementation.MetricAlertConditionImpl;
import com.microsoft.azure.management.monitor.implementation.MetricAlertResourceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasId;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.Period;
import rx.Observable;

@LangDefinition
class MetricAlertImpl
extends GroupableResourceImpl<MetricAlert, MetricAlertResourceInner, MetricAlertImpl, MonitorManager>
implements MetricAlert,
MetricAlert.Definition,
MetricAlert.Update,
MetricAlert.UpdateStages.WithMetricUpdate {
    private Map<String, MetricAlertCondition> conditions = new TreeMap<String, MetricAlertCondition>();

    MetricAlertImpl(String name, MetricAlertResourceInner innerModel, MonitorManager monitorManager) {
        super(name, (Resource)innerModel, (ManagerBase)monitorManager);
        MetricAlertSingleResourceMultipleMetricCriteria crits = (MetricAlertSingleResourceMultipleMetricCriteria)innerModel.criteria();
        if (crits != null) {
            for (MetricCriteria crit : crits.allOf()) {
                this.conditions.put(crit.name(), new MetricAlertConditionImpl(crit.name(), crit, this));
            }
        }
    }

    public Observable<MetricAlert> createResourceAsync() {
        ((MetricAlertResourceInner)((Object)this.inner())).withLocation("global");
        MetricAlertSingleResourceMultipleMetricCriteria crit = new MetricAlertSingleResourceMultipleMetricCriteria();
        crit.withAllOf(new ArrayList<MetricCriteria>());
        for (MetricAlertCondition mc : this.conditions.values()) {
            crit.allOf().add((MetricCriteria)mc.inner());
        }
        ((MetricAlertResourceInner)((Object)this.inner())).withCriteria(crit);
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).metricAlerts().createOrUpdateAsync(this.resourceGroupName(), this.name(), (MetricAlertResourceInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<MetricAlertResourceInner> getInnerAsync() {
        return ((MonitorManagementClientImpl)((Object)((MonitorManager)this.manager()).inner())).metricAlerts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public MetricAlertImpl withTargetResource(String resourceId) {
        ((MetricAlertResourceInner)((Object)this.inner())).withScopes(new ArrayList<String>());
        ((MetricAlertResourceInner)((Object)this.inner())).scopes().add(resourceId);
        return this;
    }

    @Override
    public MetricAlertImpl withTargetResource(HasId resource) {
        return this.withTargetResource(resource.id());
    }

    @Override
    public MetricAlertImpl withPeriod(Period size) {
        ((MetricAlertResourceInner)((Object)this.inner())).withWindowSize(size);
        return this;
    }

    @Override
    public MetricAlertImpl withFrequency(Period frequency) {
        ((MetricAlertResourceInner)((Object)this.inner())).withEvaluationFrequency(frequency);
        return this;
    }

    @Override
    public MetricAlertImpl withSeverity(int severity) {
        ((MetricAlertResourceInner)((Object)this.inner())).withSeverity(severity);
        return this;
    }

    @Override
    public MetricAlertImpl withAlertDetails(int severity, String description) {
        this.withSeverity(severity);
        return this.withDescription(description);
    }

    @Override
    public MetricAlertImpl withDescription(String description) {
        ((MetricAlertResourceInner)((Object)this.inner())).withDescription(description);
        return this;
    }

    @Override
    public MetricAlertImpl withRuleEnabled() {
        ((MetricAlertResourceInner)((Object)this.inner())).withEnabled(true);
        return this;
    }

    @Override
    public MetricAlertImpl withRuleDisabled() {
        ((MetricAlertResourceInner)((Object)this.inner())).withEnabled(false);
        return this;
    }

    @Override
    public MetricAlertImpl withAutoMitigation() {
        ((MetricAlertResourceInner)((Object)this.inner())).withAutoMitigate(true);
        return this;
    }

    @Override
    public MetricAlertImpl withoutAutoMitigation() {
        ((MetricAlertResourceInner)((Object)this.inner())).withAutoMitigate(false);
        return this;
    }

    @Override
    public MetricAlertImpl withActionGroups(String ... actionGroupId) {
        if (((MetricAlertResourceInner)((Object)this.inner())).actions() == null) {
            ((MetricAlertResourceInner)((Object)this.inner())).withActions(new ArrayList<MetricAlertAction>());
        }
        ((MetricAlertResourceInner)((Object)this.inner())).actions().clear();
        for (String agid : actionGroupId) {
            MetricAlertAction maa = new MetricAlertAction();
            maa.withActionGroupId(agid);
            ((MetricAlertResourceInner)((Object)this.inner())).actions().add(maa);
        }
        return this;
    }

    @Override
    public MetricAlertImpl withoutActionGroup(String actionGroupId) {
        if (((MetricAlertResourceInner)((Object)this.inner())).actions() != null) {
            ArrayList<MetricAlertAction> toDelete = new ArrayList<MetricAlertAction>();
            for (MetricAlertAction maa : ((MetricAlertResourceInner)((Object)this.inner())).actions()) {
                if (!maa.actionGroupId().equalsIgnoreCase(actionGroupId)) continue;
                toDelete.add(maa);
            }
            ((MetricAlertResourceInner)((Object)this.inner())).actions().removeAll(toDelete);
        }
        return this;
    }

    public MetricAlertConditionImpl defineAlertCriteria(String name) {
        return new MetricAlertConditionImpl(name, new MetricCriteria(), this);
    }

    @Override
    public MetricAlertConditionImpl updateAlertCriteria(String name) {
        return (MetricAlertConditionImpl)this.conditions.get(name);
    }

    @Override
    public MetricAlertImpl withoutAlertCriteria(String name) {
        if (this.conditions.containsKey(name)) {
            this.conditions.remove(name);
        }
        return this;
    }

    MetricAlertImpl withAlertCriteria(MetricAlertConditionImpl criteria) {
        this.withoutAlertCriteria(criteria.name());
        this.conditions.put(criteria.name(), criteria);
        return this;
    }

    @Override
    public String description() {
        return ((MetricAlertResourceInner)((Object)this.inner())).description();
    }

    @Override
    public int severity() {
        return ((MetricAlertResourceInner)((Object)this.inner())).severity();
    }

    @Override
    public boolean enabled() {
        return ((MetricAlertResourceInner)((Object)this.inner())).enabled();
    }

    @Override
    public Period evaluationFrequency() {
        return ((MetricAlertResourceInner)((Object)this.inner())).evaluationFrequency();
    }

    @Override
    public Period windowSize() {
        return ((MetricAlertResourceInner)((Object)this.inner())).windowSize();
    }

    @Override
    public boolean autoMitigate() {
        return ((MetricAlertResourceInner)((Object)this.inner())).autoMitigate();
    }

    @Override
    public DateTime lastUpdatedTime() {
        return ((MetricAlertResourceInner)((Object)this.inner())).lastUpdatedTime();
    }

    @Override
    public Collection<String> scopes() {
        return Collections.unmodifiableCollection(((MetricAlertResourceInner)((Object)this.inner())).scopes());
    }

    @Override
    public Collection<String> actionGroupIds() {
        if (((MetricAlertResourceInner)((Object)this.inner())).actions() != null && ((MetricAlertResourceInner)((Object)this.inner())).actions() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            for (MetricAlertAction maag : ((MetricAlertResourceInner)((Object)this.inner())).actions()) {
                ids.add(maag.actionGroupId());
            }
            return Collections.unmodifiableCollection(ids);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, MetricAlertCondition> alertCriterias() {
        return this.conditions;
    }
}

