/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.monitor.MetricDefinition;
import com.microsoft.azure.management.monitor.MetricDefinitions;
import com.microsoft.azure.management.monitor.implementation.MetricDefinitionImpl;
import com.microsoft.azure.management.monitor.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.monitor.implementation.MetricDefinitionsInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class MetricDefinitionsImpl
implements MetricDefinitions {
    private final MonitorManager myManager;

    MetricDefinitionsImpl(MonitorManager monitorManager) {
        this.myManager = monitorManager;
    }

    public MonitorManager manager() {
        return this.myManager;
    }

    public MetricDefinitionsInner inner() {
        return ((MonitorManagementClientImpl)((Object)this.myManager.inner())).metricDefinitions();
    }

    @Override
    public List<MetricDefinition> listByResource(String resourceId) {
        return Lists.transform(this.inner().list(resourceId), (Function)new Function<MetricDefinitionInner, MetricDefinition>(){

            public MetricDefinition apply(MetricDefinitionInner metricDefinitionInner) {
                return new MetricDefinitionImpl(metricDefinitionInner, MetricDefinitionsImpl.this.myManager);
            }
        });
    }

    @Override
    public Observable<MetricDefinition> listByResourceAsync(String resourceId) {
        return this.inner().listAsync(resourceId).flatMapIterable((Func1)new Func1<List<MetricDefinitionInner>, Iterable<MetricDefinitionInner>>(){

            public Iterable<MetricDefinitionInner> call(List<MetricDefinitionInner> items) {
                return items;
            }
        }).map((Func1)new Func1<MetricDefinitionInner, MetricDefinition>(){

            public MetricDefinition call(MetricDefinitionInner metricDefinitionInner) {
                return new MetricDefinitionImpl(metricDefinitionInner, MetricDefinitionsImpl.this.myManager);
            }
        });
    }
}

