/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CommonAbstractCriteria;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CommonAbstractCriteriaImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.JoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.MapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SetJoinImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class SubQueryImpl<T>
extends AbstractQueryImpl<T>
implements Subquery<T>,
InternalExpression,
InternalSelection {
    protected SelectionImpl<?> selection;
    protected SubSelectExpression currentNode;
    protected String alias;
    protected ReportQuery subQuery = new ReportQuery();
    protected Set<Join<?, ?>> correlatedJoins;
    protected CommonAbstractCriteria parent;
    protected Set<FromImpl> processedJoins;
    protected Set<Expression> correlations;

    public SubQueryImpl(Metamodel metamodel, Class result, CriteriaBuilderImpl queryBuilder, CommonAbstractCriteria parent) {
        super(metamodel, AbstractQueryImpl.ResultType.OTHER, queryBuilder, result);
        TypeImpl queryType = ((MetamodelImpl)metamodel).getType(result);
        if (queryType != null && queryType.getPersistenceType() == Type.PersistenceType.ENTITY) {
            this.subQuery.setReferenceClass(result);
        }
        this.subQuery.setDistinctState((short)2);
        this.correlatedJoins = new HashSet();
        this.correlations = new HashSet<Expression>();
        this.currentNode = new SubSelectExpression(this.subQuery, new ExpressionBuilder());
        this.parent = parent;
    }

    @Override
    public Subquery<T> select(javax.persistence.criteria.Expression<T> selection) {
        this.findRootAndParameters(selection);
        Iterator<From<Object, Object>> iterator = this.getRoots().iterator();
        while (iterator.hasNext()) {
            this.findJoins((FromImpl)((Object)iterator.next()));
        }
        iterator = this.getCorrelatedJoins().iterator();
        while (iterator.hasNext()) {
            this.findJoins((FromImpl)iterator.next());
        }
        this.selection = (SelectionImpl)((Object)selection);
        this.queryType = selection.getJavaType();
        this.subQuery.getItems().clear();
        if (selection.isCompoundSelection()) {
            int count = 0;
            for (Selection<?> select : selection.getCompoundSelectionItems()) {
                this.subQuery.addItem(String.valueOf(count), ((InternalSelection)((Object)select)).getCurrentNode());
                ++count;
            }
            this.subQuery.setExpressionBuilder(((InternalSelection)((Object)selection.getCompoundSelectionItems().get(0))).getCurrentNode().getBuilder());
        } else {
            TypeImpl type = ((MetamodelImpl)this.metamodel).getType(selection.getJavaType());
            if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                this.subQuery.addAttribute("", new ConstantExpression(1, ((InternalSelection)((Object)selection)).getCurrentNode().getBuilder()));
                this.subQuery.addNonFetchJoinedAttribute(((InternalSelection)((Object)selection)).getCurrentNode());
            } else {
                String itemName = selection.getAlias();
                if (itemName == null) {
                    itemName = ((InternalSelection)((Object)selection)).getCurrentNode().getName();
                }
                this.subQuery.addItem(itemName, ((InternalSelection)((Object)selection)).getCurrentNode());
            }
            this.subQuery.setExpressionBuilder(((InternalSelection)((Object)selection)).getCurrentNode().getBuilder());
        }
        return this;
    }

    @Override
    public Subquery<T> where(javax.persistence.criteria.Expression<Boolean> restriction) {
        super.where((javax.persistence.criteria.Expression)restriction);
        Expression currentNode = ((InternalSelection)((Object)this.where)).getCurrentNode();
        for (Expression exp : this.correlations) {
            currentNode = currentNode.and(exp);
        }
        this.subQuery.setSelectionCriteria(currentNode);
        Iterator<From<Object, Object>> iterator = this.getRoots().iterator();
        while (iterator.hasNext()) {
            this.findJoins((FromImpl)((Object)iterator.next()));
        }
        iterator = this.getCorrelatedJoins().iterator();
        while (iterator.hasNext()) {
            this.findJoins((FromImpl)iterator.next());
        }
        return this;
    }

    @Override
    public Subquery<T> where(Predicate ... restrictions) {
        super.where(restrictions);
        Expression currentNode = ((InternalSelection)((Object)this.where)).getCurrentNode();
        for (Expression exp : this.correlations) {
            currentNode = currentNode.and(exp);
        }
        this.subQuery.setSelectionCriteria(currentNode);
        Iterator<From<Object, Object>> iterator = this.getRoots().iterator();
        while (iterator.hasNext()) {
            this.findJoins((FromImpl)((Object)iterator.next()));
        }
        iterator = this.getCorrelatedJoins().iterator();
        while (iterator.hasNext()) {
            this.findJoins((FromImpl)iterator.next());
        }
        return this;
    }

    @Override
    public Subquery<T> groupBy(javax.persistence.criteria.Expression<?> ... grouping) {
        super.groupBy(grouping);
        this.subQuery.getGroupByExpressions().clear();
        javax.persistence.criteria.Expression<?>[] expressionArray = grouping;
        int n = grouping.length;
        int n2 = 0;
        while (n2 < n) {
            javax.persistence.criteria.Expression<?> groupby = expressionArray[n2];
            this.subQuery.addGrouping(((InternalSelection)((Object)groupby)).getCurrentNode());
            ++n2;
        }
        return this;
    }

    @Override
    public Subquery<T> groupBy(List<javax.persistence.criteria.Expression<?>> grouping) {
        super.groupBy(grouping);
        this.subQuery.getGroupByExpressions().clear();
        for (javax.persistence.criteria.Expression<?> groupby : grouping) {
            this.subQuery.addGrouping(((InternalSelection)((Object)groupby)).getCurrentNode());
        }
        return this;
    }

    @Override
    public Subquery<T> having(javax.persistence.criteria.Expression<Boolean> restriction) {
        super.having(restriction);
        if (this.havingClause != null) {
            this.subQuery.setHavingExpression(((InternalSelection)((Object)restriction)).getCurrentNode());
        } else {
            this.subQuery.setHavingExpression(null);
        }
        return this;
    }

    @Override
    public Subquery<T> having(Predicate ... restrictions) {
        super.having(restrictions);
        if (this.havingClause != null) {
            this.subQuery.setHavingExpression(((InternalSelection)((Object)this.havingClause)).getCurrentNode());
        } else {
            this.subQuery.setHavingExpression(null);
        }
        return this;
    }

    @Override
    public <Y> Root<Y> correlate(Root<Y> parentRoot) {
        RootImpl root = new RootImpl((ManagedType)((Object)parentRoot.getModel()), this.metamodel, parentRoot.getJavaType(), this.internalCorrelate((FromImpl)((Object)parentRoot)), parentRoot.getModel(), (FromImpl)((Object)parentRoot));
        this.integrateRoot(root);
        return root;
    }

    @Override
    public <X, Y> Join<X, Y> correlate(Join<X, Y> parentJoin) {
        this.correlatedJoins.add(parentJoin);
        JoinImpl join = new JoinImpl(parentJoin.getParentPath(), this.metamodel.managedType(parentJoin.getModel().getBindableJavaType()), this.metamodel, parentJoin.getJavaType(), this.internalCorrelate((FromImpl)((Object)parentJoin)), parentJoin.getModel(), parentJoin.getJoinType(), (FromImpl)((Object)parentJoin));
        return join;
    }

    @Override
    public <X, Y> CollectionJoin<X, Y> correlate(CollectionJoin<X, Y> parentCollection) {
        this.correlatedJoins.add(parentCollection);
        return new CollectionJoinImpl(parentCollection.getParentPath(), this.metamodel.managedType(parentCollection.getModel().getBindableJavaType()), this.metamodel, parentCollection.getJavaType(), this.internalCorrelate((FromImpl)((Object)parentCollection)), parentCollection.getModel(), parentCollection.getJoinType(), (FromImpl)((Object)parentCollection));
    }

    @Override
    public <X, Y> SetJoin<X, Y> correlate(SetJoin<X, Y> parentSet) {
        this.correlatedJoins.add(parentSet);
        return new SetJoinImpl(parentSet.getParentPath(), this.metamodel.managedType(parentSet.getModel().getBindableJavaType()), this.metamodel, parentSet.getJavaType(), ((InternalSelection)((Object)parentSet)).getCurrentNode(), parentSet.getModel(), parentSet.getJoinType(), (FromImpl)((Object)parentSet));
    }

    @Override
    public <X, Y> ListJoin<X, Y> correlate(ListJoin<X, Y> parentList) {
        this.correlatedJoins.add(parentList);
        return new ListJoinImpl(parentList.getParentPath(), this.metamodel.managedType(parentList.getModel().getBindableJavaType()), this.metamodel, parentList.getJavaType(), this.internalCorrelate((FromImpl)((Object)parentList)), parentList.getModel(), parentList.getJoinType(), (FromImpl)((Object)parentList));
    }

    @Override
    public <X, K, V> MapJoin<X, K, V> correlate(MapJoin<X, K, V> parentMap) {
        this.correlatedJoins.add(parentMap);
        return new MapJoinImpl(parentMap.getParentPath(), this.metamodel.managedType(parentMap.getModel().getBindableJavaType()), this.metamodel, parentMap.getJavaType(), this.internalCorrelate((FromImpl)((Object)parentMap)), parentMap.getModel(), parentMap.getJoinType(), (FromImpl)((Object)parentMap));
    }

    protected Expression internalCorrelate(FromImpl from) {
        Expression expression = from.getCurrentNode();
        ExpressionBuilder builder = new ExpressionBuilder(expression.getBuilder().getQueryClass());
        Expression correlated = expression.rebuildOn(builder);
        expression = expression.equal(correlated);
        this.correlations.add(expression);
        Expression selectionCriteria = expression.and(this.subQuery.getSelectionCriteria());
        this.subQuery.setSelectionCriteria(selectionCriteria);
        return correlated;
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        return ((CommonAbstractCriteriaImpl)this.getContainingQuery()).getParameters();
    }

    @Override
    public AbstractQuery<?> getParent() {
        if (this.parent == null || this.parent instanceof AbstractQuery) {
            return (AbstractQuery)this.parent;
        }
        throw new IllegalStateException("TODO.. write a better message");
    }

    @Override
    public Subquery<T> distinct(boolean distinct) {
        super.distinct(distinct);
        if (!distinct) {
            this.subQuery.setDistinctState((short)2);
        } else {
            this.subQuery.setDistinctState((short)1);
        }
        return this;
    }

    @Override
    public Expression getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public javax.persistence.criteria.Expression<T> getSelection() {
        return (javax.persistence.criteria.Expression)((Object)this.selection);
    }

    @Override
    public Set<Join<?, ?>> getCorrelatedJoins() {
        return this.correlatedJoins;
    }

    @Override
    public void addParameter(ParameterExpression<?> parameter) {
        ((CommonAbstractCriteriaImpl)this.getContainingQuery()).addParameter(parameter);
    }

    @Override
    public void addJoin(FromImpl join) {
        if (this.processedJoins == null) {
            this.processedJoins = new HashSet<FromImpl>();
        }
        if (!this.processedJoins.contains(join)) {
            this.processedJoins.add(join);
            this.subQuery.addNonFetchJoinedAttribute(join.getCurrentNode());
        }
    }

    @Override
    public <X> javax.persistence.criteria.Expression<X> as(Class<X> type) {
        return this;
    }

    @Override
    public Predicate in(Object ... values) {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(values), list, "in");
    }

    @Override
    public Predicate in(javax.persistence.criteria.Expression<?> ... values) {
        ArrayList list = new ArrayList();
        list.add(this);
        javax.persistence.criteria.Expression<?>[] expressionArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            javax.persistence.criteria.Expression<?> exp = expressionArray[n2];
            if (!((InternalExpression)((Object)exp)).isLiteral() && !((InternalExpression)((Object)exp)).isParameter()) {
                Object[] params = new Object[]{exp};
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("CRITERIA_NON_LITERAL_PASSED_TO_IN", params));
            }
            ++n2;
        }
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(values), list, "in");
    }

    @Override
    public Predicate in(Collection<?> values) {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(values), list, "in");
    }

    @Override
    public Predicate in(javax.persistence.criteria.Expression<Collection<?>> values) {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(((InternalSelection)((Object)values)).getCurrentNode()), list, "in");
    }

    @Override
    public Predicate isNotNull() {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.notNull(), list, "not null");
    }

    @Override
    public Predicate isNull() {
        ArrayList list = new ArrayList();
        list.add(this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.isNull(), list, "is null");
    }

    @Override
    public Selection<T> alias(String name) {
        this.alias = name;
        return this;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Class<T> getJavaType() {
        return this.queryType;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        throw new IllegalStateException(ExceptionLocalization.buildMessage("CRITERIA_NOT_A_COMPOUND_SELECTION"));
    }

    @Override
    public boolean isCompoundSelection() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isJunction() {
        return false;
    }

    @Override
    public boolean isPredicate() {
        return false;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isSubquery() {
        return true;
    }

    @Override
    protected void integrateRoot(RootImpl root) {
        if (this.roots.isEmpty()) {
            TypeImpl type = ((MetamodelImpl)this.metamodel).getType(this.queryType);
            if ((type != null && type.getPersistenceType() == Type.PersistenceType.ENTITY || this.queryType.equals(ClassConstants.OBJECT)) && this.selection == null) {
                this.selection = root;
                this.subQuery.getItems().clear();
                this.subQuery.addAttribute("", new ConstantExpression(1, root.getCurrentNode().getBuilder()));
                this.queryResult = AbstractQueryImpl.ResultType.ENTITY;
            }
            this.subQuery.setReferenceClass(root.getJavaType());
            this.subQuery.setExpressionBuilder(root.getCurrentNode().getBuilder());
            this.queryType = root.getJavaType();
            this.currentNode.setBaseExpression(((CommonAbstractCriteriaImpl)this.parent).getBaseExpression());
        }
        if (!this.roots.contains(root) && this.parent instanceof CriteriaQueryImpl && ((CriteriaQueryImpl)this.parent).getRoots().size() > 1) {
            this.currentNode.setBaseExpression(((CriteriaQueryImpl)this.parent).getBaseExpression(root));
        }
        super.integrateRoot(root);
    }

    @Override
    public boolean isCompoundExpression() {
        return false;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean isFrom() {
        return false;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public void findRootAndParameters(CommonAbstractCriteriaImpl query) {
        for (Join<?, ?> join : this.correlatedJoins) {
            ((JoinImpl)join).findRootAndParameters(query);
        }
    }

    @Override
    protected Expression getBaseExpression() {
        return this.currentNode.getSubQuery().getExpressionBuilder();
    }

    @Override
    public CommonAbstractCriteria getContainingQuery() {
        return this.parent;
    }

    @Override
    public DatabaseQuery getDatabaseQuery() {
        return this.subQuery;
    }
}

