/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.SDOCSUnmarshalListener;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SDOFragmentMappingAttributeAccessor
extends AttributeAccessor {
    protected SDOProperty property;
    protected HelperContext helperContext;

    public SDOFragmentMappingAttributeAccessor(SDOProperty property, HelperContext helper) {
        this.property = property;
        this.helperContext = helper;
    }

    @Override
    public Object getAttributeValueFromObject(Object anObject) throws DescriptorException {
        ArrayList<Object> attributeValue = ((SDODataObject)anObject).get(this.property);
        if (attributeValue != null) {
            if (this.property.isMany()) {
                ArrayList<Object> fragments = new ArrayList<Object>();
                Iterator objects = ((Collection)attributeValue).iterator();
                while (objects.hasNext()) {
                    fragments.add(this.buildFragment(this.property, (SDODataObject)anObject, (SDODataObject)objects.next()));
                }
                attributeValue = fragments;
            } else {
                attributeValue = this.buildFragment(this.property, (SDODataObject)anObject, (SDODataObject)((Object)attributeValue));
            }
        }
        return attributeValue;
    }

    @Override
    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
    }

    @Override
    public boolean isMethodAttributeAccessor() {
        return true;
    }

    @Override
    public void setAttributeValueInObject(Object domainObject, Object attributeValue) throws DescriptorException {
        XMLUnmarshaller unmarshaller = ((SDOXMLHelper)this.helperContext.getXMLHelper()).getXmlContext().createUnmarshaller();
        unmarshaller.setUnmarshalListener(new SDOCSUnmarshalListener(this.helperContext));
        if (attributeValue instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Node next : (Collection)attributeValue) {
                Object dataObject = unmarshaller.unmarshal(next);
                if (dataObject instanceof XMLRoot) {
                    dataObject = ((XMLRoot)dataObject).getObject();
                }
                result.add(dataObject);
            }
            ((SDODataObject)domainObject).set(this.property, result);
        } else {
            Node value;
            Object result = null;
            if (attributeValue != null && (result = unmarshaller.unmarshal(value = (Node)attributeValue)) instanceof XMLRoot) {
                result = ((XMLRoot)result).getObject();
            }
            ((SDODataObject)domainObject).set(this.property, result);
        }
    }

    public void setProperty(SDOProperty property) {
        this.property = property;
    }

    public SDOProperty getPropertyName() {
        return this.property;
    }

    private Object buildFragment(Property property, SDODataObject parentObject, SDODataObject value) {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        XMLMarshaller xmlMarshaller = ((SDOXMLHelper)this.helperContext.getXMLHelper()).getXmlContext().createMarshaller();
        Document doc = xmlPlatform.createDocument();
        XMLRoot root = new XMLRoot();
        root.setObject(value);
        root.setLocalName(property.getName());
        if (((SDOProperty)property).isNamespaceQualified()) {
            root.setNamespaceURI(parentObject.getType().getURI());
        }
        xmlMarshaller.marshal((Object)root, doc);
        return doc.getDocumentElement();
    }
}

