/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayFrontend;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.network.PublicIPAddress;
import com.microsoft.azure.management.network.Subnet;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayFrontendIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.ApplicationGatewayImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

@LangDefinition
class ApplicationGatewayFrontendImpl
extends ChildResourceImpl<ApplicationGatewayFrontendIPConfigurationInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayFrontend,
ApplicationGatewayFrontend.Definition<ApplicationGateway.DefinitionStages.WithListener>,
ApplicationGatewayFrontend.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayFrontend.Update {
    ApplicationGatewayFrontendImpl(ApplicationGatewayFrontendIPConfigurationInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
    }

    public String networkId() {
        SubResource subnetRef = ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.parentResourceIdFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    public String subnetName() {
        SubResource subnetRef = ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).subnet();
        if (subnetRef != null) {
            return ResourceUtils.nameFromResourceId((String)subnetRef.id());
        }
        return null;
    }

    @Override
    public String privateIPAddress() {
        return ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).privateIPAddress();
    }

    @Override
    public IPAllocationMethod privateIPAllocationMethod() {
        return ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).privateIPAllocationMethod();
    }

    public String name() {
        return ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).name();
    }

    @Override
    public String publicIPAddressId() {
        if (((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).publicIPAddress() != null) {
            return ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).publicIPAddress().id();
        }
        return null;
    }

    @Override
    public boolean isPublic() {
        return ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).publicIPAddress() != null;
    }

    @Override
    public boolean isPrivate() {
        return ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).subnet() != null;
    }

    public ApplicationGatewayFrontendImpl withExistingSubnet(Network network, String subnetName) {
        return this.withExistingSubnet(network.id(), subnetName);
    }

    public ApplicationGatewayFrontendImpl withExistingSubnet(String parentNetworkResourceId, String subnetName) {
        SubResource subnetRef = new SubResource().withId(parentNetworkResourceId + "/subnets/" + subnetName);
        ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).withSubnet(subnetRef);
        this.withoutPublicIPAddress();
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withExistingPublicIPAddress(PublicIPAddress pip) {
        return this.withExistingPublicIPAddress(pip.id());
    }

    @Override
    public ApplicationGatewayFrontendImpl withExistingPublicIPAddress(String resourceId) {
        SubResource pipRef = new SubResource().withId(resourceId);
        ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).withPublicIPAddress(pipRef);
        this.withoutSubnet();
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withoutPublicIPAddress() {
        ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).withPublicIPAddress(null);
        return this;
    }

    public ApplicationGatewayFrontendImpl withoutSubnet() {
        ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).withSubnet(null).withPrivateIPAddress(null).withPrivateIPAllocationMethod(null);
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withPrivateIPAddressDynamic() {
        ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(null).withPrivateIPAllocationMethod(IPAllocationMethod.DYNAMIC);
        return this;
    }

    @Override
    public ApplicationGatewayFrontendImpl withPrivateIPAddressStatic(String ipAddress) {
        ((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).withPrivateIPAddress(ipAddress).withPrivateIPAllocationMethod(IPAllocationMethod.STATIC);
        return this;
    }

    @Override
    public Subnet getSubnet() {
        return ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).getAssociatedSubnet(((ApplicationGatewayFrontendIPConfigurationInner)((Object)this.inner())).subnet());
    }

    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withFrontend(this);
    }

    @Override
    public PublicIPAddress getPublicIPAddress() {
        String pipId = this.publicIPAddressId();
        if (pipId == null) {
            return null;
        }
        return (PublicIPAddress)((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).publicIPAddresses().getById(pipId);
    }
}

