/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ha;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.ranger.ha.CuratorFactory;
import org.apache.ranger.ha.HAConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceState {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceState.class);
    private Configuration configuration;
    private volatile ServiceStateValue state;
    private static volatile ServiceState instance;

    private ServiceState() throws Exception {
    }

    private ServiceState(Configuration configuration) {
        this.configuration = configuration;
        this.state = !HAConfiguration.isHAEnabled(configuration) ? ServiceStateValue.ACTIVE : ServiceStateValue.PASSIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceState getInstance(Configuration configuration) {
        if (instance != null) return instance;
        Class<CuratorFactory> clazz = CuratorFactory.class;
        synchronized (CuratorFactory.class) {
            if (instance != null) return instance;
            try {
                instance = new ServiceState(configuration);
            }
            catch (Exception e) {
                LOG.info("HA is not enabled so not initialising curator ServiceState", (Object)e.getMessage());
            }
            return instance;
        }
    }

    public ServiceStateValue getState() {
        return this.state;
    }

    public void becomingActive() {
        LOG.warn("Instance becoming active from {}", (Object)this.state);
        this.setState(ServiceStateValue.BECOMING_ACTIVE);
    }

    private void setState(ServiceStateValue newState) {
        Preconditions.checkState((boolean)HAConfiguration.isHAEnabled(this.configuration), (Object)"Cannot change state as requested, as HA is not enabled for this instance.");
        this.state = newState;
    }

    public void setActive() {
        LOG.warn("Instance is active from {}", (Object)this.state);
        this.setState(ServiceStateValue.ACTIVE);
    }

    public void becomingPassive() {
        LOG.warn("Instance becoming passive from {}" + (Object)((Object)this.state));
        this.setState(ServiceStateValue.BECOMING_PASSIVE);
    }

    public void setPassive() {
        LOG.warn("Instance is passive from {}", (Object)this.state);
        this.setState(ServiceStateValue.PASSIVE);
    }

    public boolean isInstanceInTransition() {
        ServiceStateValue state = this.getState();
        return state == ServiceStateValue.BECOMING_ACTIVE || state == ServiceStateValue.BECOMING_PASSIVE;
    }

    public void setMigration() {
        LOG.warn("Instance in {}" + (Object)((Object)this.state));
        this.setState(ServiceStateValue.MIGRATING);
    }

    public boolean isInstanceInMigration() {
        return this.getState() == ServiceStateValue.MIGRATING;
    }

    public static enum ServiceStateValue {
        ACTIVE,
        PASSIVE,
        BECOMING_ACTIVE,
        BECOMING_PASSIVE,
        MIGRATING;

    }
}

