/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swc;

import java.io.File;
import java.io.IOException;
import org.apache.royale.compiler.caches.IAssetTagCache;
import org.apache.royale.compiler.caches.ICSSDocumentCache;
import org.apache.royale.compiler.caches.IFileScopeCache;
import org.apache.royale.compiler.caches.ISWFCache;
import org.apache.royale.compiler.internal.caches.AssetTagCache;
import org.apache.royale.compiler.internal.caches.CSSDocumentCache;
import org.apache.royale.compiler.internal.caches.CacheStoreKeyBase;
import org.apache.royale.compiler.internal.caches.ConcurrentCacheStoreBase;
import org.apache.royale.compiler.internal.caches.FileScopeCache;
import org.apache.royale.compiler.internal.caches.SWFCache;
import org.apache.royale.compiler.workspaces.IWorkspace;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCLibrary;
import org.apache.royale.swc.ISWCManager;
import org.apache.royale.swc.ISWCScript;
import org.apache.royale.swc.io.SWCReader;

public class SWCManager
extends ConcurrentCacheStoreBase<ISWC>
implements ISWCManager {
    private final SWFCache swfCache = new SWFCache(this);
    private final FileScopeCache fileScopeCache = new FileScopeCache(this);
    private final AssetTagCache assetTagCache = new AssetTagCache(this);
    private final CSSDocumentCache cssDocumentCache = new CSSDocumentCache();
    private final IWorkspace workspace;

    public SWCManager(IWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public ISWFCache getSWFCache() {
        return this.swfCache;
    }

    @Override
    public IFileScopeCache getFileScopeCache() {
        return this.fileScopeCache;
    }

    @Override
    public IAssetTagCache getAssetTagCache() {
        return this.assetTagCache;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    protected ISWC createEntryValue(CacheStoreKeyBase key) {
        if (key instanceof SWCCacheKey) {
            SWCCacheKey cacheKey = (SWCCacheKey)key;
            SWCReader reader = new SWCReader(cacheKey.file, this.workspace.getASDocDelegate().getPackageDitaParser());
            ISWC swc = reader.getSWC();
            assert (swc != null) : "Expect a SWC model object.";
            return swc;
        }
        throw new IllegalArgumentException("Expected a SWCCacheKey.");
    }

    @Override
    public ISWC get(File file) {
        ISWC result = (ISWC)this.get(new SWCCacheKey(file));
        return result;
    }

    @Override
    public void remove(File file) {
        ISWC removedSWC = (ISWC)this.remove(new SWCCacheKey(file));
        if (removedSWC == null) {
            return;
        }
        for (ISWCLibrary lib : removedSWC.getLibraries()) {
            String librarySWFPath = lib.getPath();
            for (ISWCScript script : lib.getScripts()) {
                this.fileScopeCache.remove(FileScopeCache.createKey(removedSWC, librarySWFPath, script));
                for (String scriptDefQName : script.getDefinitions()) {
                    this.assetTagCache.remove(AssetTagCache.createKey(removedSWC, librarySWFPath, script, scriptDefQName));
                }
            }
            this.swfCache.remove(SWFCache.createKey(removedSWC, lib.getPath()));
        }
        for (String defaultsCSSFileName : CSSDocumentCache.ALL_DEFAULTS_CSS_FILENAMES) {
            this.cssDocumentCache.remove(CSSDocumentCache.createKey(removedSWC, defaultsCSSFileName));
        }
        for (String fileInSWC : removedSWC.getFiles().keySet()) {
            this.swfCache.remove(SWFCache.createKey(removedSWC, fileInSWC));
        }
    }

    @Override
    public ICSSDocumentCache getCSSDocumentCache() {
        return this.cssDocumentCache;
    }

    public static class SWCCacheKey
    extends CacheStoreKeyBase {
        private final File file;

        public SWCCacheKey(File file) {
            assert (file != null) : "SWC file can't be null.";
            this.file = file;
        }

        @Override
        public String generateKey() {
            try {
                return this.file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

