/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.api.event.Event;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.event.EnumeratorCloseEvent;
import org.apache.seatunnel.api.source.event.EnumeratorOpenEvent;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.config.MultipleTableFakeSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.fake.source.FakeSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.fake.state.FakeSourceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeSourceSplitEnumerator
implements SourceSplitEnumerator<FakeSourceSplit, FakeSourceState> {
    private static final Logger log = LoggerFactory.getLogger(FakeSourceSplitEnumerator.class);
    private final SourceSplitEnumerator.Context<FakeSourceSplit> enumeratorContext;
    private final Map<Integer, Set<FakeSourceSplit>> pendingSplits;
    private final MultipleTableFakeSourceConfig multipleTableFakeSourceConfig;
    private final Set<FakeSourceSplit> assignedSplits;
    private final Object lock = new Object();

    public FakeSourceSplitEnumerator(SourceSplitEnumerator.Context<FakeSourceSplit> enumeratorContext, MultipleTableFakeSourceConfig multipleTableFakeSourceConfig, Set<FakeSourceSplit> assignedSplits) {
        this.enumeratorContext = enumeratorContext;
        this.pendingSplits = new HashMap<Integer, Set<FakeSourceSplit>>();
        this.multipleTableFakeSourceConfig = multipleTableFakeSourceConfig;
        this.assignedSplits = new HashSet<FakeSourceSplit>(assignedSplits);
    }

    public void open() {
        this.enumeratorContext.getEventListener().onEvent((Event)new EnumeratorOpenEvent());
    }

    public void run() throws Exception {
        this.discoverySplits();
        this.assignPendingSplits();
    }

    public void close() throws IOException {
        this.enumeratorContext.getEventListener().onEvent((Event)new EnumeratorCloseEvent());
    }

    public void addSplitsBack(List<FakeSourceSplit> splits, int subtaskId) {
        log.debug("Fake source add splits back {}, subtaskId:{}", splits, (Object)subtaskId);
        this.addSplitChangeToPendingAssignments(splits);
    }

    public int currentUnassignedSplitSize() {
        return this.pendingSplits.size();
    }

    public void handleSplitRequest(int subtaskId) {
    }

    public void registerReader(int subtaskId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FakeSourceState snapshotState(long checkpointId) throws Exception {
        log.debug("Get lock, begin snapshot fakesource split enumerator...");
        Object object = this.lock;
        synchronized (object) {
            log.debug("Begin snapshot fakesource split enumerator...");
            return new FakeSourceState(this.assignedSplits);
        }
    }

    public void notifyCheckpointComplete(long checkpointId) {
    }

    private void discoverySplits() {
        HashSet<FakeSourceSplit> allSplit = new HashSet<FakeSourceSplit>();
        log.info("Starting to calculate splits.");
        int numReaders = this.enumeratorContext.currentParallelism();
        for (FakeConfig fakeConfig : this.multipleTableFakeSourceConfig.getFakeConfigs()) {
            String tableId = fakeConfig.getCatalogTable().getTableId().toTablePath().toString();
            int readerRowNum = fakeConfig.getRowNum();
            int splitNum = fakeConfig.getSplitNum();
            int splitRowNum = (int)Math.ceil((double)readerRowNum / (double)splitNum);
            for (int i = 0; i < numReaders; ++i) {
                int index = i;
                for (int num = 0; num < readerRowNum; num += splitRowNum) {
                    allSplit.add(new FakeSourceSplit(tableId, index, Math.min(splitRowNum, readerRowNum - num)));
                    index += numReaders;
                }
            }
            log.info("Calculated splits for table {} successfully, the size of splits is {}.", (Object)tableId, (Object)allSplit.size());
        }
        this.assignedSplits.forEach(allSplit::remove);
        this.addSplitChangeToPendingAssignments(allSplit);
        log.info("Assigned {} to {} readers.", allSplit, (Object)numReaders);
        log.info("Calculated splits successfully, the size of splits is {}.", (Object)allSplit.size());
    }

    private void addSplitChangeToPendingAssignments(Collection<FakeSourceSplit> newSplits) {
        for (FakeSourceSplit split : newSplits) {
            int ownerReader = split.getSplitId() % this.enumeratorContext.currentParallelism();
            this.pendingSplits.computeIfAbsent(ownerReader, r -> new HashSet()).add(split);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignPendingSplits() {
        Iterator iterator = this.enumeratorContext.registeredReaders().iterator();
        while (iterator.hasNext()) {
            int pendingReader = (Integer)iterator.next();
            Set<FakeSourceSplit> pendingAssignmentForReader = this.pendingSplits.remove(pendingReader);
            if (pendingAssignmentForReader == null || pendingAssignmentForReader.isEmpty()) continue;
            Object object = this.lock;
            synchronized (object) {
                this.assignedSplits.addAll(pendingAssignmentForReader);
                log.info("Assigning splits to readers {} {}", (Object)pendingReader, pendingAssignmentForReader);
                this.enumeratorContext.assignSplit(pendingReader, new ArrayList<FakeSourceSplit>(pendingAssignmentForReader));
                this.enumeratorContext.signalNoMoreSplits(pendingReader);
            }
        }
    }
}

