/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.SqlPageCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlErrorCodec;
import com.hazelcast.client.impl.protocol.codec.custom.SqlQueryIdCodec;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.client.SqlError;
import com.hazelcast.sql.impl.client.SqlPage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class SqlFetchCodec {
    public static final int REQUEST_MESSAGE_TYPE = 2163968;
    public static final int RESPONSE_MESSAGE_TYPE = 2163969;
    private static final int REQUEST_CURSOR_BUFFER_SIZE_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 20;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private SqlFetchCodec() {
    }

    public static ClientMessage encodeRequest(QueryId queryId, int cursorBufferSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Sql.Fetch");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2163968);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, cursorBufferSize);
        clientMessage.add(initialFrame);
        SqlQueryIdCodec.encode(clientMessage, queryId);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.cursorBufferSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.queryId = SqlQueryIdCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(@Nullable SqlPage rowPage, @Nullable SqlError error) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2163969);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, rowPage, SqlPageCodec::encode);
        CodecUtil.encodeNullable(clientMessage, error, SqlErrorCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        response.rowPage = CodecUtil.decodeNullable(iterator, SqlPageCodec::decode);
        response.error = CodecUtil.decodeNullable(iterator, SqlErrorCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        @Nullable
        public SqlPage rowPage;
        @Nullable
        public SqlError error;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public QueryId queryId;
        public int cursorBufferSize;
    }
}

