/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.dynamicconfig;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.dynamicconfig.ClusterWideConfigurationService;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.permission.ConfigPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public abstract class AbstractAddConfigMessageTask<P>
extends AbstractMessageTask<P>
implements BiConsumer<Object, Throwable> {
    private static final ConfigPermission CONFIG_PERMISSION = new ConfigPermission();

    public AbstractAddConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public String getServiceName() {
        return "hz:configurationService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return CONFIG_PERMISSION;
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public final void processMessage() {
        IdentifiedDataSerializable config = this.getConfig();
        ClusterWideConfigurationService service = (ClusterWideConfigurationService)this.getService("hz:configurationService");
        if (this.checkStaticConfigDoesNotExist(config)) {
            service.broadcastConfigAsync(config).whenCompleteAsync((BiConsumer)this);
        } else {
            this.sendResponse(null);
        }
    }

    @Override
    public void accept(Object response, Throwable throwable) {
        if (throwable == null) {
            this.sendResponse(response);
        } else {
            this.handleProcessingFailure(throwable);
        }
    }

    protected MergePolicyConfig mergePolicyConfig(String mergePolicy, int batchSize) {
        return new MergePolicyConfig(mergePolicy, batchSize);
    }

    protected List<? extends ListenerConfig> adaptListenerConfigs(List<ListenerConfigHolder> listenerConfigHolders) {
        if (listenerConfigHolders == null || listenerConfigHolders.isEmpty()) {
            return null;
        }
        ArrayList itemListenerConfigs = new ArrayList();
        for (ListenerConfigHolder listenerConfigHolder : listenerConfigHolders) {
            itemListenerConfigs.add(listenerConfigHolder.asListenerConfig(this.serializationService));
        }
        return itemListenerConfigs;
    }

    protected abstract IdentifiedDataSerializable getConfig();

    protected abstract boolean checkStaticConfigDoesNotExist(IdentifiedDataSerializable var1);
}

