/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy.txn;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapDeleteCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapGetForUpdateCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapKeySetWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapPutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapRemoveIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapReplaceIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapSetCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapValuesCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionalMapValuesWithPredicateCodec;
import com.hazelcast.client.impl.proxy.txn.ClientTxnProxy;
import com.hazelcast.client.impl.spi.ClientTransactionContext;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.transaction.TransactionalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientTxnMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMap<K, V> {
    public ClientTxnMapProxy(String name, ClientTransactionContext transactionContext) {
        super(name, transactionContext);
    }

    @Override
    public boolean containsKey(Object key) {
        Preconditions.checkNotNull(key, "key can't be null");
        ClientMessage request = TransactionalMapContainsKeyCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key));
        ClientMessage response = this.invoke(request);
        return TransactionalMapContainsKeyCodec.decodeResponse(response);
    }

    @Override
    public V get(Object key) {
        Preconditions.checkNotNull(key, "key can't be null");
        ClientMessage request = TransactionalMapGetCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapGetCodec.decodeResponse(response));
    }

    @Override
    public V getForUpdate(Object key) {
        Preconditions.checkNotNull(key, "key can't be null");
        ClientMessage request = TransactionalMapGetForUpdateCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapGetForUpdateCodec.decodeResponse(response));
    }

    @Override
    public int size() {
        ClientMessage request = TransactionalMapSizeCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        return TransactionalMapSizeCodec.decodeResponse(response);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        ClientMessage request = TransactionalMapPutCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key), this.toData(value), timeunit.toMillis(ttl));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapPutCodec.decodeResponse(response));
    }

    @Override
    public void set(K key, V value) {
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        ClientMessage request = TransactionalMapSetCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key), this.toData(value));
        this.invoke(request);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        ClientMessage request = TransactionalMapPutIfAbsentCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key), this.toData(value));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapPutIfAbsentCodec.decodeResponse(response));
    }

    @Override
    public V replace(K key, V value) {
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        ClientMessage request = TransactionalMapReplaceCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key), this.toData(value));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapReplaceCodec.decodeResponse(response));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(oldValue, "oldValue can't be null");
        Preconditions.checkNotNull(newValue, "newValue can't be null");
        ClientMessage request = TransactionalMapReplaceIfSameCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key), this.toData(oldValue), this.toData(newValue));
        ClientMessage response = this.invoke(request);
        return TransactionalMapReplaceIfSameCodec.decodeResponse(response);
    }

    @Override
    public V remove(Object key) {
        Preconditions.checkNotNull(key, "key can't be null");
        ClientMessage request = TransactionalMapRemoveCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key));
        ClientMessage response = this.invoke(request);
        return (V)this.toObject(TransactionalMapRemoveCodec.decodeResponse(response));
    }

    @Override
    public void delete(Object key) {
        Preconditions.checkNotNull(key, "key can't be null");
        ClientMessage request = TransactionalMapDeleteCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key));
        this.invoke(request);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull(key, "key can't be null");
        Preconditions.checkNotNull(value, "value can't be null");
        ClientMessage request = TransactionalMapRemoveIfSameCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(key), this.toData(value));
        ClientMessage response = this.invoke(request);
        return TransactionalMapRemoveIfSameCodec.decodeResponse(response);
    }

    @Override
    public Set<K> keySet() {
        ClientMessage request = TransactionalMapKeySetCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        List<Data> dataKeySet = TransactionalMapKeySetCodec.decodeResponse(response);
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        Preconditions.checkNotNull(predicate, "predicate can't null");
        ClientMessage request = TransactionalMapKeySetWithPredicateCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(predicate));
        ClientMessage response = this.invoke(request);
        List<Data> dataKeySet = TransactionalMapKeySetWithPredicateCodec.decodeResponse(response);
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        ClientMessage request = TransactionalMapValuesCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId());
        ClientMessage response = this.invoke(request);
        List<Data> dataValues = TransactionalMapValuesCodec.decodeResponse(response);
        return new UnmodifiableLazyList(dataValues, this.getSerializationService());
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        Preconditions.checkNotNull(predicate, "predicate can't be null");
        ClientMessage request = TransactionalMapValuesWithPredicateCodec.encodeRequest(this.name, this.getTransactionId(), ThreadUtil.getThreadId(), this.toData(predicate));
        ClientMessage response = this.invoke(request);
        List<Data> dataValues = TransactionalMapValuesWithPredicateCodec.decodeResponse(response);
        ArrayList<Object> values = new ArrayList<Object>(dataValues.size());
        for (Data value : dataValues) {
            values.add(this.toObject(value));
        }
        return values;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    void onDestroy() {
    }
}

