/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.atomiclong;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.spi.atomic.RaftAtomicValue;

public class AtomicLong
extends RaftAtomicValue<Long> {
    private volatile long value;

    AtomicLong(CPGroupId groupId, String name, long value) {
        super(groupId, name);
        this.value = value;
    }

    public long addAndGet(long delta) {
        this.value += delta;
        return this.value;
    }

    public long getAndAdd(long delta) {
        long v = this.value;
        this.value += delta;
        return v;
    }

    public long getAndSet(long value) {
        long v = this.value;
        this.value = value;
        return v;
    }

    public boolean compareAndSet(long currentValue, long newValue) {
        if (this.value == currentValue) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public long value() {
        return this.value;
    }

    @Override
    public Long get() {
        return this.value;
    }

    public String toString() {
        return "AtomicLong{groupId=" + this.groupId() + ", name='" + this.name() + '\'' + ", value=" + this.value + '}';
    }
}

