/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.UrgentSystemOperation;
import java.util.concurrent.Callable;

final class UrgentPartitionRunnable<T>
implements PartitionSpecificRunnable,
UrgentSystemOperation {
    final InternalCompletableFuture<T> future = new InternalCompletableFuture();
    private final int partitionId;
    private final Callable<T> callable;

    UrgentPartitionRunnable(int partitionId, Runnable runnable) {
        this.partitionId = partitionId;
        this.callable = () -> {
            runnable.run();
            return null;
        };
    }

    UrgentPartitionRunnable(int partitionId, Callable callable) {
        this.partitionId = partitionId;
        this.callable = callable;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public void run() {
        try {
            this.future.complete(this.callable.call());
        }
        catch (Exception e) {
            this.future.completeExceptionally(e);
        }
    }
}

