/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.util.IterableUtil;
import com.hazelcast.internal.util.LocalRetryableExecution;
import com.hazelcast.internal.util.futures.ChainingFuture;
import com.hazelcast.internal.util.iterator.RestartingMemberIterator;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public final class InvocationUtil {
    private InvocationUtil() {
    }

    public static <V> InternalCompletableFuture<V> invokeOnStableClusterSerial(NodeEngine nodeEngine, Supplier<? extends Operation> operationSupplier, int maxRetries) {
        ClusterService clusterService = nodeEngine.getClusterService();
        if (!clusterService.isJoined()) {
            return InternalCompletableFuture.newCompletedFuture(null);
        }
        RestartingMemberIterator memberIterator = new RestartingMemberIterator(clusterService, maxRetries);
        InvokeOnMemberFunction invokeOnMemberFunction = new InvokeOnMemberFunction(operationSupplier, nodeEngine, memberIterator);
        Iterator invocationIterator = IterableUtil.map(memberIterator, invokeOnMemberFunction);
        return new ChainingFuture(invocationIterator, memberIterator);
    }

    public static LocalRetryableExecution executeLocallyWithRetry(NodeEngine nodeEngine, Operation operation) {
        if (operation.getOperationResponseHandler() != null) {
            throw new IllegalArgumentException("Operation must not have a response handler set");
        }
        if (!operation.returnsResponse()) {
            throw new IllegalArgumentException("Operation must return a response");
        }
        if (operation.validatesTarget()) {
            throw new IllegalArgumentException("Operation must not validate the target");
        }
        LocalRetryableExecution execution = new LocalRetryableExecution(nodeEngine, operation);
        execution.run();
        return execution;
    }

    private static class InvokeOnMemberFunction
    implements Function<Member, InternalCompletableFuture<Object>> {
        private final transient Supplier<? extends Operation> operationSupplier;
        private final transient NodeEngine nodeEngine;
        private final transient RestartingMemberIterator memberIterator;
        private final long retryDelayMillis;
        private volatile int lastRetryCount;

        InvokeOnMemberFunction(Supplier<? extends Operation> operationSupplier, NodeEngine nodeEngine, RestartingMemberIterator memberIterator) {
            this.operationSupplier = operationSupplier;
            this.nodeEngine = nodeEngine;
            this.memberIterator = memberIterator;
            this.retryDelayMillis = nodeEngine.getProperties().getMillis(ClusterProperty.INVOCATION_RETRY_PAUSE);
        }

        @Override
        public InternalCompletableFuture<Object> apply(Member member) {
            if (this.isRetry()) {
                return this.invokeOnMemberWithDelay(member);
            }
            return this.invokeOnMember(member);
        }

        private boolean isRetry() {
            int currentRetryCount = this.memberIterator.getRetryCount();
            if (this.lastRetryCount == currentRetryCount) {
                return false;
            }
            this.lastRetryCount = currentRetryCount;
            return true;
        }

        private InternalCompletableFuture<Object> invokeOnMemberWithDelay(Member member) {
            InternalCompletableFuture<Object> future = new InternalCompletableFuture<Object>();
            InvokeOnMemberTask task = new InvokeOnMemberTask(member, future);
            this.nodeEngine.getExecutionService().schedule(task, this.retryDelayMillis, TimeUnit.MILLISECONDS);
            return future;
        }

        private InternalCompletableFuture<Object> invokeOnMember(Member member) {
            Address address = member.getAddress();
            Operation operation = this.operationSupplier.get();
            String serviceName = operation.getServiceName();
            return this.nodeEngine.getOperationService().invokeOnTarget(serviceName, operation, address);
        }

        private class InvokeOnMemberTask
        implements Runnable {
            private final Member member;
            private final CompletableFuture<Object> future;

            InvokeOnMemberTask(Member member, CompletableFuture<Object> future) {
                this.member = member;
                this.future = future;
            }

            @Override
            public void run() {
                InvokeOnMemberFunction.this.invokeOnMember(this.member).whenCompleteAsync((response, t) -> {
                    if (t == null) {
                        this.future.complete(response);
                    } else {
                        this.future.completeExceptionally((Throwable)t);
                    }
                });
            }
        }
    }
}

