/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public final class IterableUtil {
    private IterableUtil() {
    }

    public static <T> T getFirst(Iterable<T> iterable, T defaultValue) {
        Iterator<T> iterator = iterable.iterator();
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public static <T, R> Iterable<R> map(Iterable<T> iterable, Function<T, R> mapper) {
        return () -> IterableUtil.map(iterable.iterator(), mapper);
    }

    public static <T, R> Iterator<R> map(final Iterator<T> iterator, final Function<T, R> mapper) {
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public R next() {
                return mapper.apply(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> Iterable<T> filter(Iterable<T> iterable, final Predicate<T> filter) {
        final Iterator<T> givenIterator = iterable.iterator();
        Iterator filteringIterator = new Iterator<T>(){
            private T next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (givenIterator.hasNext()) {
                    Object temp = givenIterator.next();
                    if (!filter.test(temp)) continue;
                    this.next = temp;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object nextLocal = this.next;
                this.next = null;
                return nextLocal;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return () -> filteringIterator;
    }

    public static int size(Iterable iterable) {
        Preconditions.checkNotNull(iterable, "iterable cannot be null");
        int size = 0;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static <T, R> Iterator<R> limit(final Iterator<R> iterator, final int limit) {
        return new Iterator<R>(){
            private int iterated;

            @Override
            public boolean hasNext() {
                return this.iterated < limit && iterator.hasNext();
            }

            @Override
            public R next() {
                ++this.iterated;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> Iterable<T> nullToEmpty(Iterable<T> iterable) {
        return iterable == null ? Collections.emptyList() : iterable;
    }

    public static <T> Iterator<T> asReadOnlyIterator(final Iterator<T> iterator) {
        if (iterator instanceof UnmodifiableIterator) {
            return iterator;
        }
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }
}

