/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class InstanceConfig {
    public static final int DEFAULT_FLOW_CONTROL_PERIOD_MS = 100;
    public static final int DEFAULT_BACKUP_COUNT = 1;
    private static final long SCALE_UP_DELAY_MILLIS_DEFAULT = TimeUnit.SECONDS.toMillis(10L);
    private static final long MAX_PROCESSOR_ACCUMULATED_RECORDS = Long.MAX_VALUE;
    private int cooperativeThreadCount = RuntimeAvailableProcessors.get();
    private int flowControlPeriodMs = 100;
    private int backupCount = 1;
    private long scaleUpDelayMillis = SCALE_UP_DELAY_MILLIS_DEFAULT;
    private boolean losslessRestartEnabled;
    private long maxProcessorAccumulatedRecords = Long.MAX_VALUE;

    @Nonnull
    public InstanceConfig setCooperativeThreadCount(int size) {
        Preconditions.checkPositive(size, "cooperativeThreadCount should be a positive number");
        this.cooperativeThreadCount = size;
        return this;
    }

    public int getCooperativeThreadCount() {
        return this.cooperativeThreadCount;
    }

    @Nonnull
    public InstanceConfig setFlowControlPeriodMs(int flowControlPeriodMs) {
        Preconditions.checkPositive(flowControlPeriodMs, "flowControlPeriodMs should be a positive number");
        this.flowControlPeriodMs = flowControlPeriodMs;
        return this;
    }

    public int getFlowControlPeriodMs() {
        return this.flowControlPeriodMs;
    }

    @Nonnull
    public InstanceConfig setBackupCount(int newBackupCount) {
        Preconditions.checkBackupCount(newBackupCount, 0);
        this.backupCount = newBackupCount;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public InstanceConfig setScaleUpDelayMillis(long millis) {
        Preconditions.checkNotNegative(millis, "The delay must be >=0");
        this.scaleUpDelayMillis = millis;
        return this;
    }

    public long getScaleUpDelayMillis() {
        return this.scaleUpDelayMillis;
    }

    public boolean isLosslessRestartEnabled() {
        return this.losslessRestartEnabled;
    }

    public InstanceConfig setLosslessRestartEnabled(boolean enabled) {
        this.losslessRestartEnabled = enabled;
        return this;
    }

    public InstanceConfig setMaxProcessorAccumulatedRecords(long maxProcessorAccumulatedRecords) {
        Preconditions.checkPositive(maxProcessorAccumulatedRecords, "maxProcessorAccumulatedRecords must be a positive number");
        this.maxProcessorAccumulatedRecords = maxProcessorAccumulatedRecords;
        return this;
    }

    public long getMaxProcessorAccumulatedRecords() {
        return this.maxProcessorAccumulatedRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceConfig)) {
            return false;
        }
        InstanceConfig that = (InstanceConfig)o;
        if (this.cooperativeThreadCount != that.cooperativeThreadCount) {
            return false;
        }
        if (this.flowControlPeriodMs != that.flowControlPeriodMs) {
            return false;
        }
        if (this.backupCount != that.backupCount) {
            return false;
        }
        if (this.scaleUpDelayMillis != that.scaleUpDelayMillis) {
            return false;
        }
        if (this.maxProcessorAccumulatedRecords != that.maxProcessorAccumulatedRecords) {
            return false;
        }
        return this.losslessRestartEnabled == that.losslessRestartEnabled;
    }

    public int hashCode() {
        int result = this.cooperativeThreadCount;
        result = 31 * result + this.flowControlPeriodMs;
        result = 31 * result + this.backupCount;
        result = 31 * result + (int)(this.scaleUpDelayMillis ^ this.scaleUpDelayMillis >>> 32);
        result = 31 * result + (this.losslessRestartEnabled ? 1 : 0);
        result = 31 * result + (int)(this.maxProcessorAccumulatedRecords ^ this.maxProcessorAccumulatedRecords >>> 32);
        return result;
    }
}

