/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.serialization;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.HeapMemoryAccessor;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.serialization.MemoryReader;
import java.nio.ByteOrder;

public class UnsafeMemoryReader
implements MemoryReader {
    private final boolean reverse;

    UnsafeMemoryReader(ByteOrder byteOrder) {
        Preconditions.checkState(GlobalMemoryAccessorRegistry.MEM_AVAILABLE, "unsafe memory access is not available");
        this.reverse = ByteOrder.nativeOrder() != byteOrder;
    }

    @Override
    public int readInt(byte[] bytes, int offset) {
        int value = GlobalMemoryAccessorRegistry.MEM.getInt(bytes, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + offset);
        return this.reverse ? Integer.reverseBytes(value) : value;
    }

    @Override
    public long readLong(byte[] bytes, int offset) {
        long value = GlobalMemoryAccessorRegistry.MEM.getLong(bytes, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + offset);
        return this.reverse ? Long.reverseBytes(value) : value;
    }
}

