/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import java.util.concurrent.TimeUnit;

public final class ExpirationTimeSetter {
    private ExpirationTimeSetter() {
    }

    public static long nextExpirationTime(long ttlMillis, long maxIdleMillis, long now, long lastUpdateTime) {
        long nextTtlExpirationTime = ExpirationTimeSetter.nextTtlExpirationTime(ttlMillis, lastUpdateTime);
        long nextMaxIdleExpirationTime = ExpirationTimeSetter.nextMaxIdleExpirationTime(maxIdleMillis, now);
        return Math.min(nextTtlExpirationTime, nextMaxIdleExpirationTime);
    }

    private static long nextTtlExpirationTime(long ttlMillis, long lastUpdateTime) {
        return ExpirationTimeSetter.handleOverflow(ttlMillis + lastUpdateTime);
    }

    private static long nextMaxIdleExpirationTime(long maxIdleMillis, long now) {
        return ExpirationTimeSetter.handleOverflow(maxIdleMillis + now);
    }

    private static long handleOverflow(long time) {
        return time <= 0L ? Long.MAX_VALUE : time;
    }

    public static boolean isTtlOrMaxIdleConfigured(long time) {
        return time > 0L && time < Long.MAX_VALUE;
    }

    public static long pickTTLMillis(MapConfig mapConfig, long operationTTLMillis) {
        if (operationTTLMillis < 0L && mapConfig.getTimeToLiveSeconds() == 0) {
            return Long.MAX_VALUE;
        }
        if (operationTTLMillis > 0L) {
            return operationTTLMillis;
        }
        if (operationTTLMillis == 0L) {
            return Long.MAX_VALUE;
        }
        if (mapConfig.getTimeToLiveSeconds() > 0) {
            return TimeUnit.SECONDS.toMillis(mapConfig.getTimeToLiveSeconds());
        }
        return Long.MAX_VALUE;
    }

    public static long pickMaxIdleMillis(MapConfig mapConfig, long operationMaxIdleMillis) {
        if (operationMaxIdleMillis < 0L && mapConfig.getMaxIdleSeconds() == 0) {
            return Long.MAX_VALUE;
        }
        if (operationMaxIdleMillis > 0L) {
            return operationMaxIdleMillis;
        }
        if (operationMaxIdleMillis == 0L) {
            return Long.MAX_VALUE;
        }
        if (mapConfig.getMaxIdleSeconds() > 0) {
            return TimeUnit.SECONDS.toMillis(mapConfig.getMaxIdleSeconds());
        }
        return Long.MAX_VALUE;
    }
}

