/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.recordstore.JsonMetadataStore;
import com.hazelcast.query.impl.JsonMetadata;
import com.hazelcast.query.impl.Metadata;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JsonMetadataStoreImpl
implements JsonMetadataStore {
    private final ConcurrentMap<Data, JsonMetadata> store = new ConcurrentHashMap<Data, JsonMetadata>();

    @Override
    public JsonMetadata get(Data key) {
        return (JsonMetadata)this.store.get(key);
    }

    @Override
    public void set(Data key, JsonMetadata metadata) {
        this.store.put(key, metadata);
    }

    @Override
    public void setKey(Data key, Object metadataKey) {
        Metadata metadata = (Metadata)this.store.get(key);
        if (metadata == null) {
            if (metadataKey == null) {
                return;
            }
            this.store.put(key, new Metadata(metadataKey, null));
        } else {
            metadata.setKeyMetadata(metadataKey);
            if (metadata.getKeyMetadata() == null && metadata.getValueMetadata() == null) {
                this.store.remove(key);
            }
        }
    }

    @Override
    public void setValue(Data key, Object metadataValue) {
        Metadata metadata = (Metadata)this.store.get(key);
        if (metadata == null) {
            if (metadataValue == null) {
                return;
            }
            this.store.put(key, new Metadata(null, metadataValue));
        } else {
            metadata.setValueMetadata(metadataValue);
            if (metadata.getKeyMetadata() == null && metadata.getValueMetadata() == null) {
                this.store.remove(key);
            }
        }
    }

    @Override
    public void remove(Data key) {
        this.store.remove(key);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void destroy() {
    }
}

