/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.utils;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.spi.exception.RestClientException;
import com.hazelcast.spi.utils.RetryUtils;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public final class RestClient {
    public static final int HTTP_OK = 200;
    public static final int HTTP_NOT_FOUND = 404;
    private final String url;
    private final List<Parameter> headers = new ArrayList<Parameter>();
    private Set<Integer> expectedResponseCodes;
    private String body;
    private int readTimeoutSeconds;
    private int connectTimeoutSeconds;
    private int retries;
    private String caCertificate;

    protected RestClient(String url) {
        this.url = url;
    }

    public static RestClient create(String url) {
        return new RestClient(url);
    }

    public RestClient withHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.withHeader(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public RestClient withHeader(String name, String value) {
        this.headers.add(new Parameter(name, value));
        return this;
    }

    public RestClient withBody(String body) {
        this.body = body;
        return this;
    }

    public RestClient withReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return this;
    }

    public RestClient withConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return this;
    }

    public RestClient withRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public RestClient withCaCertificates(String caCertificate) {
        this.caCertificate = caCertificate;
        return this;
    }

    public RestClient expectResponseCodes(Integer ... codes) {
        if (this.expectedResponseCodes == null) {
            this.expectedResponseCodes = new HashSet<Integer>();
        }
        this.expectedResponseCodes.addAll(Arrays.asList(codes));
        return this;
    }

    public Response get() {
        return this.callWithRetries("GET");
    }

    public Response post() {
        return this.callWithRetries("POST");
    }

    private Response callWithRetries(String method) {
        return RetryUtils.retry(() -> this.call(method), this.retries);
    }

    private Response call(String method) {
        HttpURLConnection connection = null;
        try {
            URL urlToConnect = new URL(this.url);
            connection = (HttpURLConnection)urlToConnect.openConnection();
            if (connection instanceof HttpsURLConnection && this.caCertificate != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.buildSslSocketFactory());
            }
            connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(this.readTimeoutSeconds));
            connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(this.connectTimeoutSeconds));
            connection.setRequestMethod(method);
            for (Parameter header : this.headers) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            if (this.body != null) {
                byte[] bodyData = this.body.getBytes(StandardCharsets.UTF_8);
                connection.setDoOutput(true);
                connection.setRequestProperty("charset", "utf-8");
                connection.setRequestProperty("Content-Length", Integer.toString(bodyData.length));
                try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
                    outputStream.write(bodyData);
                    outputStream.flush();
                }
            }
            this.checkResponseCode(method, connection);
            Response response = new Response(connection.getResponseCode(), RestClient.read(connection));
            return response;
        }
        catch (IOException e) {
            throw new RestClientException("Failure in executing REST call", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void checkResponseCode(String method, HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (!this.isExpectedResponseCode(responseCode)) {
            String errorMessage;
            try {
                errorMessage = RestClient.read(connection);
            }
            catch (Exception e) {
                throw new RestClientException(String.format("Failure executing: %s at: %s", method, this.url), responseCode);
            }
            throw new RestClientException(String.format("Failure executing: %s at: %s. Message: %s", method, this.url, errorMessage), responseCode);
        }
    }

    private boolean isExpectedResponseCode(int responseCode) {
        return this.expectedResponseCodes == null ? responseCode == 200 : this.expectedResponseCodes.contains(responseCode);
    }

    private SSLSocketFactory buildSslSocketFactory() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            int i = 0;
            for (Certificate certificate : this.generateCertificates()) {
                String alias = String.format("ca-%d", i++);
                keyStore.setCertificateEntry(alias, certificate);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
            sSLContext.init(null, tmf.getTrustManagers(), null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RestClientException("Failure in generating SSLSocketFactory", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends Certificate> generateCertificates() throws CertificateException {
        Collection<? extends Certificate> collection;
        ByteArrayInputStream caInput = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            caInput = new ByteArrayInputStream(this.caCertificate.getBytes(StandardCharsets.UTF_8));
            collection = cf.generateCertificates(caInput);
        }
        catch (Throwable throwable) {
            IOUtil.closeResource(caInput);
            throw throwable;
        }
        IOUtil.closeResource(caInput);
        return collection;
    }

    private static String read(HttpURLConnection connection) {
        InputStream stream;
        try {
            stream = connection.getInputStream();
        }
        catch (IOException e) {
            stream = connection.getErrorStream();
        }
        if (stream == null) {
            return null;
        }
        Scanner scanner = new Scanner(stream, "UTF-8");
        scanner.useDelimiter("\\Z");
        return scanner.next();
    }

    private static final class Parameter {
        private final String key;
        private final String value;

        private Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        private String getKey() {
            return this.key;
        }

        private String getValue() {
            return this.value;
        }
    }

    public static class Response {
        private final int code;
        private final String body;

        Response(int code, String body) {
            this.code = code;
            this.body = body;
        }

        public int getCode() {
            return this.code;
        }

        public String getBody() {
            return this.body;
        }
    }
}

