/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.Contexts;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ExpressionEvalContext {
    public static final String SQL_ARGUMENTS_KEY_NAME = "__sql.arguments";
    private final List<Object> arguments;
    private final InternalSerializationService serializationService;

    public ExpressionEvalContext(@Nonnull List<Object> arguments, @Nonnull InternalSerializationService serializationService) {
        this.arguments = Objects.requireNonNull(arguments);
        this.serializationService = Objects.requireNonNull(serializationService);
    }

    public static ExpressionEvalContext from(ProcessorSupplier.Context ctx) {
        return new ExpressionEvalContext((List)Objects.requireNonNull(ctx.jobConfig().getArgument(SQL_ARGUMENTS_KEY_NAME)), ((Contexts.ProcSupplierCtx)ctx).serializationService());
    }

    public Object getArgument(int index) {
        return this.arguments.get(index);
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }
}

