/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.BiExpressionWithType;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.math.BigDecimal;

public final class MultiplyFunction<T>
extends BiExpressionWithType<T>
implements IdentifiedDataSerializable {
    public MultiplyFunction() {
    }

    private MultiplyFunction(Expression<?> operand1, Expression<?> operand2, QueryDataType resultType) {
        super(operand1, operand2, resultType);
    }

    public static MultiplyFunction<?> create(Expression<?> operand1, Expression<?> operand2, QueryDataType resultType) {
        return new MultiplyFunction(operand1, operand2, resultType);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 19;
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object left = this.operand1.eval(row, context);
        if (left == null) {
            return null;
        }
        Object right = this.operand2.eval(row, context);
        if (right == null) {
            return null;
        }
        QueryDataTypeFamily family = this.resultType.getTypeFamily();
        if (family.isTemporal()) {
            throw new UnsupportedOperationException("temporal types are unsupported currently");
        }
        return (T)MultiplyFunction.evalNumeric((Number)left, (Number)right, family);
    }

    private static Object evalNumeric(Number left, Number right, QueryDataTypeFamily family) {
        switch (family) {
            case TINYINT: {
                return (byte)(left.byteValue() * right.byteValue());
            }
            case SMALLINT: {
                return (short)(left.shortValue() * right.shortValue());
            }
            case INTEGER: {
                return left.intValue() * right.intValue();
            }
            case BIGINT: {
                try {
                    return Math.multiplyExact(left.longValue(), right.longValue());
                }
                catch (ArithmeticException e) {
                    throw QueryException.error(2000, "BIGINT overflow in '*' operator (consider adding explicit CAST to DECIMAL)");
                }
            }
            case REAL: {
                return Float.valueOf(left.floatValue() * right.floatValue());
            }
            case DOUBLE: {
                return left.doubleValue() * right.doubleValue();
            }
            case DECIMAL: {
                return ((BigDecimal)left).multiply((BigDecimal)right, ExpressionMath.DECIMAL_MATH_CONTEXT);
            }
        }
        throw new IllegalArgumentException("unexpected result family: " + (Object)((Object)family));
    }
}

