/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.env;

import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.sink.SaveModeExecuteLocation;
import org.apache.seatunnel.common.constants.JobMode;

public interface EnvCommonOptions {
    public static final Option<Integer> PARALLELISM = Options.key("parallelism").intType().defaultValue(1).withDescription("When parallelism is not specified in connector, the parallelism in env is used by default. When parallelism is specified, it will override the parallelism in env.");
    public static final Option<String> JOB_NAME = Options.key("job.name").stringType().defaultValue("SeaTunnel_Job").withDescription("The job name of this job");
    public static final Option<JobMode> JOB_MODE = Options.key("job.mode").enumType(JobMode.class).defaultValue(JobMode.BATCH).withDescription("The job mode of this job, support Batch and Stream");
    public static final Option<Integer> JOB_RETRY_TIMES = Options.key("job.retry.times").intType().defaultValue(3).withDescription("The retry times of this job");
    public static final Option<Integer> JOB_RETRY_INTERVAL_SECONDS = Options.key("job.retry.interval.seconds").intType().defaultValue(3).withDescription("The retry interval seconds of this job");
    public static final Option<Long> CHECKPOINT_INTERVAL = Options.key("checkpoint.interval").longType().noDefaultValue().withDescription("The interval (in milliseconds) between two consecutive checkpoints.");
    public static final Option<Integer> READ_LIMIT_ROW_PER_SECOND = Options.key("read_limit.rows_per_second").intType().noDefaultValue().withDescription("The each parallelism row limit per second for read data from source.");
    public static final Option<Integer> READ_LIMIT_BYTES_PER_SECOND = Options.key("read_limit.bytes_per_second").intType().noDefaultValue().withDescription("The each parallelism bytes limit per second for read data from source.");
    public static final Option<Long> CHECKPOINT_TIMEOUT = Options.key("checkpoint.timeout").longType().noDefaultValue().withDescription("The timeout (in milliseconds) for a checkpoint.");
    public static final Option<SaveModeExecuteLocation> SAVEMODE_EXECUTE_LOCATION = Options.key("savemode.execute.location").enumType(SaveModeExecuteLocation.class).defaultValue(SaveModeExecuteLocation.CLUSTER).withDescription("The location of save mode execute.");
    public static final Option<String> JARS = Options.key("jars").stringType().noDefaultValue().withDescription("third-party packages can be loaded via `jars`");
    public static final Option<Map<String, String>> CUSTOM_PARAMETERS = Options.key("custom_parameters").mapType().noDefaultValue().withDescription("custom parameters for run engine");
    public static final Option<Map<String, String>> NODE_TAG_FILTER = Options.key("tag_filter").mapType().noDefaultValue().withDescription("Define the worker where the job runs by tag");
}

