/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.TablePath;

public final class TableIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String catalogName;
    private final String databaseName;
    private final String schemaName;
    @NonNull
    private final String tableName;

    public TableIdentifier(String catalogName, String databaseName, String schemaName, @NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        if (StringUtils.isEmpty(tableName)) {
            throw new IllegalArgumentException("tableName cannot be empty");
        }
    }

    public static TableIdentifier of(String catalogName, String databaseName, String tableName) {
        return new TableIdentifier(catalogName, databaseName, null, tableName);
    }

    public static TableIdentifier of(String catalogName, TablePath tablePath) {
        return new TableIdentifier(catalogName, tablePath.getDatabaseName(), tablePath.getSchemaName(), tablePath.getTableName());
    }

    public static TableIdentifier of(String catalogName, String databaseName, String schemaName, String tableName) {
        return new TableIdentifier(catalogName, databaseName, schemaName, tableName);
    }

    public TablePath toTablePath() {
        return TablePath.of(this.databaseName, this.schemaName, this.tableName);
    }

    public TableIdentifier copy() {
        return TableIdentifier.of(this.catalogName, this.databaseName, this.schemaName, this.tableName);
    }

    public String toString() {
        if (this.schemaName == null) {
            return String.join((CharSequence)".", this.catalogName, this.databaseName, this.tableName);
        }
        return String.join((CharSequence)".", this.catalogName, this.databaseName, this.schemaName, this.tableName);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @NonNull
    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableIdentifier)) {
            return false;
        }
        TableIdentifier other = (TableIdentifier)o;
        String this$catalogName = this.getCatalogName();
        String other$catalogName = other.getCatalogName();
        if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalogName = this.getCatalogName();
        result = result * 59 + ($catalogName == null ? 43 : $catalogName.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }
}

