/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.factory;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.TablePlaceholder;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.factory.TableFactoryContext;

public class TableSinkFactoryContext
extends TableFactoryContext {
    private final CatalogTable catalogTable;

    @VisibleForTesting
    public TableSinkFactoryContext(CatalogTable catalogTable, ReadonlyConfig options, ClassLoader classLoader) {
        super(options, classLoader);
        if (catalogTable != null) {
            TableSinkFactoryContext.checkCatalogTableIllegal(Collections.singletonList(catalogTable));
        }
        this.catalogTable = catalogTable;
    }

    public static TableSinkFactoryContext replacePlaceholderAndCreate(CatalogTable catalogTable, ReadonlyConfig options, ClassLoader classLoader, Collection<String> excludeTablePlaceholderReplaceKeys) {
        ReadonlyConfig rewriteConfig = TablePlaceholder.replaceTablePlaceholder(options, catalogTable, excludeTablePlaceholderReplaceKeys);
        return new TableSinkFactoryContext(catalogTable, rewriteConfig, classLoader);
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }
}

