/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.execution;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskExecutionContext;
import org.apache.seatunnel.engine.server.execution.TaskGroup;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;

public class TaskGroupDefaultImpl
implements TaskGroup {
    private final TaskGroupLocation taskGroupLocation;
    private final String taskGroupName;
    private final Map<Long, Task> tasks;

    public TaskGroupDefaultImpl(TaskGroupLocation taskGroupLocation, String taskGroupName, Collection<Task> tasks) {
        this.taskGroupLocation = taskGroupLocation;
        this.taskGroupName = taskGroupName;
        this.tasks = tasks.stream().collect(Collectors.toMap(Task::getTaskID, Function.identity()));
    }

    public String getTaskGroupName() {
        return this.taskGroupName;
    }

    @Override
    public TaskGroupLocation getTaskGroupLocation() {
        return this.taskGroupLocation;
    }

    @Override
    public void init() {
    }

    @Override
    public Collection<Task> getTasks() {
        return this.tasks.values();
    }

    @Override
    public <T extends Task> T getTask(long taskID) {
        return (T)this.tasks.get(taskID);
    }

    @Override
    public void setTasksContext(Map<Long, TaskExecutionContext> taskExecutionContextMap) {
    }
}

