/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.metrics.JobMetricsUtil;
import org.apache.seatunnel.engine.server.serializable.ClientToServerOperationDataSerializerHook;

public class GetRunningJobMetricsOperation
extends Operation
implements IdentifiedDataSerializable,
AllowedDuringPassiveState {
    private String response;

    @Override
    public final int getFactoryId() {
        return ClientToServerOperationDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
    }

    @Override
    public void run() {
        SeaTunnelServer service = (SeaTunnelServer)this.getService();
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> JobMetricsUtil.toJsonString(service.getCoordinatorService().getRunningJobMetrics()), this.getNodeEngine().getExecutionService().getExecutor("get_running_job_metrics_operation"));
        try {
            this.response = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getResponse() {
        return this.response;
    }
}

