/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import com.hazelcast.cluster.Address;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.MultiTableResourceManager;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SupportResourceShare;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.server.checkpoint.ActionStateKey;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointBarrier;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointCloseReason;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointException;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskAcknowledgeOperation;
import org.apache.seatunnel.engine.server.execution.ProgressState;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.CoordinatorTask;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.apache.seatunnel.engine.server.task.statemachine.SeaTunnelTaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkAggregatedCommitterTask<CommandInfoT, AggregatedCommitInfoT>
extends CoordinatorTask {
    private static final Logger log = LoggerFactory.getLogger(SinkAggregatedCommitterTask.class);
    private static final long serialVersionUID = 5906594537520393503L;
    private volatile SeaTunnelTaskState currState;
    private final SinkAction<?, ?, CommandInfoT, AggregatedCommitInfoT> sink;
    private final int maxWriterSize;
    private final SinkAggregatedCommitter<CommandInfoT, AggregatedCommitInfoT> aggregatedCommitter;
    private transient Serializer<AggregatedCommitInfoT> aggregatedCommitInfoSerializer;
    private transient Serializer<CommandInfoT> commitInfoSerializer;
    private Map<Long, Address> writerAddressMap;
    private ConcurrentMap<Long, List<CommandInfoT>> commitInfoCache;
    private ConcurrentMap<Long, List<AggregatedCommitInfoT>> checkpointCommitInfoMap;
    private Map<Long, Integer> checkpointBarrierCounter;
    private CompletableFuture<Void> completableFuture;
    private MultiTableResourceManager resourceManager;
    private volatile boolean receivedSinkWriter;

    public SinkAggregatedCommitterTask(long jobID, TaskLocation taskID, SinkAction<?, ?, CommandInfoT, AggregatedCommitInfoT> sink, SinkAggregatedCommitter<CommandInfoT, AggregatedCommitInfoT> aggregatedCommitter) {
        super(jobID, taskID);
        this.sink = sink;
        this.aggregatedCommitter = aggregatedCommitter;
        this.maxWriterSize = sink.getParallelism();
        this.receivedSinkWriter = false;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.currState = SeaTunnelTaskState.INIT;
        this.checkpointBarrierCounter = new ConcurrentHashMap<Long, Integer>();
        this.commitInfoCache = new ConcurrentHashMap<Long, List<CommandInfoT>>();
        this.writerAddressMap = new ConcurrentHashMap<Long, Address>();
        this.checkpointCommitInfoMap = new ConcurrentHashMap<Long, List<AggregatedCommitInfoT>>();
        this.completableFuture = new CompletableFuture();
        this.commitInfoSerializer = this.sink.getSink().getCommitInfoSerializer().get();
        this.aggregatedCommitInfoSerializer = this.sink.getSink().getAggregatedCommitInfoSerializer().get();
        if (this.aggregatedCommitter instanceof SupportResourceShare) {
            this.resourceManager = ((SupportResourceShare)((Object)this.aggregatedCommitter)).initMultiTableResourceManager(1, 1);
        }
        this.aggregatedCommitter.init();
        if (this.resourceManager != null) {
            ((SupportResourceShare)((Object)this.aggregatedCommitter)).setMultiTableResourceManager(this.resourceManager, 0);
        }
        log.debug("starting seatunnel sink aggregated committer task, sink name[{}] ", (Object)this.sink.getName());
    }

    public void receivedWriterRegister(TaskLocation writerID, Address address) {
        this.writerAddressMap.put(writerID.getTaskID(), address);
        if (this.maxWriterSize <= this.writerAddressMap.size()) {
            this.receivedSinkWriter = true;
        }
    }

    @Override
    @NonNull
    public ProgressState call() throws Exception {
        this.stateProcess();
        return this.progress.toState();
    }

    protected void stateProcess() throws Exception {
        switch (this.currState) {
            case INIT: {
                this.currState = SeaTunnelTaskState.WAITING_RESTORE;
                this.reportTaskStatus(SeaTunnelTaskState.WAITING_RESTORE);
                break;
            }
            case WAITING_RESTORE: {
                if (this.restoreComplete.isDone()) {
                    this.currState = SeaTunnelTaskState.READY_START;
                    this.reportTaskStatus(SeaTunnelTaskState.READY_START);
                    break;
                }
                Thread.sleep(100L);
                break;
            }
            case READY_START: {
                if (this.startCalled) {
                    this.currState = SeaTunnelTaskState.STARTING;
                    break;
                }
                Thread.sleep(100L);
                break;
            }
            case STARTING: {
                if (this.receivedSinkWriter) {
                    this.currState = SeaTunnelTaskState.RUNNING;
                    break;
                }
                Thread.sleep(100L);
                break;
            }
            case RUNNING: {
                if (this.prepareCloseStatus) {
                    this.currState = SeaTunnelTaskState.PREPARE_CLOSE;
                    break;
                }
                Thread.sleep(100L);
                break;
            }
            case PREPARE_CLOSE: {
                if (this.closeCalled) {
                    this.currState = SeaTunnelTaskState.CLOSED;
                    break;
                }
                Thread.sleep(100L);
                break;
            }
            case CLOSED: {
                this.close();
                return;
            }
            case CANCELLING: {
                this.close();
                this.currState = SeaTunnelTaskState.CANCELED;
                return;
            }
            default: {
                throw new IllegalArgumentException("Unknown Enumerator State: " + this.currState);
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.aggregatedCommitter.close();
        this.progress.done();
        this.completableFuture.complete(null);
        try {
            if (this.resourceManager != null) {
                this.resourceManager.close();
            }
        }
        catch (Throwable e) {
            log.error("close resourceManager error", e);
        }
    }

    private long getClosedWriters(Barrier barrier) {
        return barrier.closedTasks().stream().filter(task -> this.writerAddressMap.containsKey(task.getTaskID())).count();
    }

    @Override
    public void triggerBarrier(Barrier barrier) throws Exception {
        long startTime = System.currentTimeMillis();
        log.debug("trigger barrier for sink agg commit [{}]", (Object)barrier);
        Integer count = this.checkpointBarrierCounter.compute(barrier.getId(), (id, num) -> {
            int n;
            if (num == null) {
                n = 1;
            } else {
                num = num + 1;
                n = num;
            }
            return n;
        });
        if ((long)count.intValue() != (long)this.maxWriterSize - this.getClosedWriters(barrier)) {
            return;
        }
        if (barrier.prepareClose(this.taskLocation)) {
            this.prepareCloseStatus = true;
            this.prepareCloseBarrierId.set(barrier.getId());
        }
        if (barrier.snapshot()) {
            if (this.commitInfoCache.containsKey(barrier.getId())) {
                log.debug("commitInfoCache contains Key [{}]", (Object)barrier.getId());
                AggregatedCommitInfoT aggregatedCommitInfoT = this.aggregatedCommitter.combine((List)this.commitInfoCache.get(barrier.getId()));
                log.debug("get the aggregatedCommitInfoT [{}]", (Object)aggregatedCommitInfoT);
                this.checkpointCommitInfoMap.put(barrier.getId(), Collections.singletonList(aggregatedCommitInfoT));
            }
            List orDefault = this.checkpointCommitInfoMap.getOrDefault(barrier.getId(), Collections.emptyList());
            log.debug("final store commit info size [{}]", (Object)orDefault.size());
            log.debug("final store commit info [{}]", (Object)orDefault);
            List<byte[]> states = SinkAggregatedCommitterTask.serializeStates(this.aggregatedCommitInfoSerializer, this.checkpointCommitInfoMap.getOrDefault(barrier.getId(), Collections.emptyList()));
            this.getExecutionContext().sendToMaster(new TaskAcknowledgeOperation(this.taskLocation, (CheckpointBarrier)barrier, Collections.singletonList(new ActionSubtaskState(ActionStateKey.of(this.sink), -1, states)))).join();
        }
        log.debug("trigger barrier [{}] finished, cost {}ms. taskLocation [{}]", barrier.getId(), System.currentTimeMillis() - startTime, this.taskLocation);
    }

    @Override
    public void restoreState(List<ActionSubtaskState> actionStateList) throws Exception {
        log.debug("restoreState for sink agg committer [{}]", (Object)actionStateList);
        List aggregatedCommitInfos = actionStateList.stream().map(ActionSubtaskState::getState).flatMap(Collection::stream).filter(Objects::nonNull).map(bytes -> ExceptionUtil.sneaky(() -> this.aggregatedCommitInfoSerializer.deserialize((byte[])bytes))).collect(Collectors.toList());
        List<AggregatedCommitInfoT> commit = this.aggregatedCommitter.restoreCommit(aggregatedCommitInfos);
        if (CollectionUtils.isNotEmpty(commit)) {
            log.error("aggregated committer error: {}", (Object)commit.size());
            throw new CheckpointException(CheckpointCloseReason.AGGREGATE_COMMIT_ERROR);
        }
        this.restoreComplete.complete(null);
        log.debug("restoreState for sink agg committer [{}] finished", (Object)actionStateList);
    }

    public void receivedWriterCommitInfo(long checkpointID, CommandInfoT commitInfos) {
        log.debug("received writer commit infos checkpoint id [{}], commitInfos [{}]", (Object)checkpointID, (Object)commitInfos);
        this.commitInfoCache.computeIfAbsent(checkpointID, id -> new CopyOnWriteArrayList());
        ((List)this.commitInfoCache.get(checkpointID)).add(commitInfos);
    }

    @Override
    public Set<URL> getJarsUrl() {
        return new HashSet<URL>(this.sink.getJarUrls());
    }

    @Override
    public Set<ConnectorJarIdentifier> getConnectorPluginJars() {
        return new HashSet<ConnectorJarIdentifier>(this.sink.getConnectorJarIdentifiers());
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        ArrayList aggregatedCommitInfo = new ArrayList();
        this.checkpointCommitInfoMap.forEach((key, value) -> {
            if (key > checkpointId) {
                return;
            }
            aggregatedCommitInfo.addAll(value);
            this.checkpointCommitInfoMap.remove(key);
        });
        List<AggregatedCommitInfoT> commit = this.aggregatedCommitter.commit(aggregatedCommitInfo);
        this.tryClose(checkpointId);
        if (!CollectionUtils.isEmpty(commit)) {
            log.error("aggregated committer error: {}", (Object)commit.size());
            throw new CheckpointException(CheckpointCloseReason.AGGREGATE_COMMIT_ERROR);
        }
    }

    @Override
    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        this.aggregatedCommitter.abort((List)this.checkpointCommitInfoMap.get(checkpointId));
        this.checkpointCommitInfoMap.remove(checkpointId);
        this.tryClose(checkpointId);
    }

    public Serializer<CommandInfoT> getCommitInfoSerializer() {
        return this.commitInfoSerializer;
    }
}

