/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.codehaus.janino.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.seatunnel.shade.org.codehaus.commons.nullanalysis.Nullable;

public class TeeReader
extends FilterReader {
    private final Writer out;
    private final boolean closeWriterOnEOF;

    public TeeReader(Reader in, Writer out, boolean closeWriterOnEof) {
        super(in);
        this.out = out;
        this.closeWriterOnEOF = closeWriterOnEof;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.out.close();
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            if (this.closeWriterOnEOF) {
                this.out.close();
            } else {
                this.out.flush();
            }
        } else {
            this.out.write(c);
        }
        return c;
    }

    @Override
    public int read(@Nullable char[] cbuf, int off, int len) throws IOException {
        int bytesRead = this.in.read(cbuf, off, len);
        if (bytesRead == -1) {
            if (this.closeWriterOnEOF) {
                this.out.close();
            } else {
                this.out.flush();
            }
        } else {
            this.out.write(cbuf, off, bytesRead);
        }
        return bytesRead;
    }
}

