/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import org.apache.sedona.common.Functions;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class GeometryForce4DTransformer
extends GeometryTransformer {
    private static boolean hasZ;
    private static boolean hasM;
    private final double mValue;
    private final double zValue;

    public GeometryForce4DTransformer(double zValue, double mValue) {
        this.zValue = zValue;
        this.mValue = mValue;
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
        Coordinate[] newCoords = new CoordinateXYZM[coords.size()];
        for (int i = 0; i < coords.size(); ++i) {
            Coordinate coordinate = coords.getCoordinate(i);
            newCoords[i] = new CoordinateXYZM(coordinate.getX(), coordinate.getY(), hasZ ? coordinate.getZ() : this.zValue, hasM ? coordinate.getM() : this.mValue);
        }
        return this.createCoordinateSequence(newCoords);
    }

    public static Geometry transform(Geometry geometry, double zValue, double mValue) {
        if (geometry.getCoordinates().length == 0) {
            return geometry;
        }
        hasZ = Functions.hasZ(geometry);
        hasM = Functions.hasM(geometry);
        if (hasZ && hasM) {
            return geometry;
        }
        GeometryForce4DTransformer transformer = new GeometryForce4DTransformer(zValue, mValue);
        return transformer.transform(geometry);
    }
}

