/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.adapters;

import java.io.Serializable;
import org.apache.sedona.core.spatialPartitioning.GenericUniquePartitioner;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.sql.utils.GeometrySerializer$;
import org.apache.sedona.util.DfUtils$;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class StructuredAdapter$ {
    public static StructuredAdapter$ MODULE$;
    private final Logger logger;

    static {
        new StructuredAdapter$();
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public SpatialRDD<Geometry> toSpatialRdd(RDD<Row> rdd, String geometryFieldName) {
        void var3_3;
        SpatialRDD spatialRDD = new SpatialRDD();
        spatialRDD.schema = rdd.isEmpty() ? StructType$.MODULE$.apply((Seq)Nil$.MODULE$) : ((Row)rdd.first()).schema();
        spatialRDD.rawSpatialRDD = JavaRDD$.MODULE$.fromRDD(rdd.map((Function1 & Serializable & scala.Serializable)row -> {
            void var2_2;
            Geometry geom = (Geometry)row.getAs(geometryFieldName);
            geom.setUserData(row.copy());
            return var2_2;
        }, ClassTag$.MODULE$.apply(Geometry.class)), ClassTag$.MODULE$.apply(Geometry.class));
        return var3_3;
    }

    public SpatialRDD<Geometry> toSpatialRdd(RDD<Row> rdd) {
        Predef$.MODULE$.require(rdd.count() > 0L, (Function0 & Serializable & scala.Serializable)() -> "Input RDD cannot be empty.");
        return this.toSpatialRdd(rdd, DfUtils$.MODULE$.getGeometryColumnName(((Row)rdd.first()).schema()));
    }

    public RDD<Row> toRowRdd(SpatialRDD<Geometry> spatialRDD) {
        return JavaRDD$.MODULE$.toRDD(spatialRDD.rawSpatialRDD.map((Function & Serializable)geometry -> {
            void var1_1;
            Row row = (Row)geometry.getUserData();
            return var1_1;
        }));
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, String geometryFieldName) {
        return this.toSpatialRdd((RDD<InternalRow>)dataFrame.queryExecution().toRdd(), dataFrame.schema(), geometryFieldName);
    }

    public SpatialRDD<Geometry> toSpatialRdd(RDD<InternalRow> rdd, StructType schema, String geometryFieldName) {
        SpatialRDD<Geometry> spatialRDD = new SpatialRDD<Geometry>();
        spatialRDD.schema = schema;
        int ordinal = spatialRDD.schema.fieldIndex(geometryFieldName);
        spatialRDD.rawSpatialRDD = JavaRDD$.MODULE$.fromRDD(rdd.map((Function1 & Serializable & scala.Serializable)row -> {
            void var2_2;
            Geometry geom = GeometrySerializer$.MODULE$.deserialize(row.getBinary(ordinal));
            geom.setUserData(row.copy());
            return var2_2;
        }, ClassTag$.MODULE$.apply(Geometry.class)), ClassTag$.MODULE$.apply(Geometry.class));
        return spatialRDD;
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame) {
        return this.toSpatialRdd(dataFrame, DfUtils$.MODULE$.getGeometryColumnName(dataFrame.schema()));
    }

    public Dataset<Row> toDf(SpatialRDD<Geometry> spatialRDD, SparkSession sparkSession) {
        JavaRDD rowRdd = spatialRDD.rawSpatialRDD.map((Function & Serializable)geometry -> {
            void var1_1;
            InternalRow row = (InternalRow)geometry.getUserData();
            return var1_1;
        });
        return sparkSession.internalCreateDataFrame(JavaRDD$.MODULE$.toRDD(rowRdd), spatialRDD.schema, sparkSession.internalCreateDataFrame$default$3());
    }

    public Dataset<Row> toSpatialPartitionedDf(SpatialRDD<Geometry> spatialRDD, SparkSession sparkSession) {
        if (spatialRDD.spatialPartitionedRDD == null) {
            throw new RuntimeException("SpatialRDD is not spatially partitioned. Please call spatialPartitioning method before calling this method.");
        }
        if (!(spatialRDD.getPartitioner() instanceof GenericUniquePartitioner)) {
            this.logger().warn("SpatialPartitionedRDD might have duplicate geometries. Please make sure you are aware of it.");
        }
        JavaRDD rowRdd = spatialRDD.spatialPartitionedRDD.map((Function & Serializable)geometry -> {
            void var1_1;
            InternalRow row = (InternalRow)geometry.getUserData();
            return var1_1;
        });
        return sparkSession.internalCreateDataFrame(JavaRDD$.MODULE$.toRDD(rowRdd), spatialRDD.schema, sparkSession.internalCreateDataFrame$default$3());
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, String leftSchemaJson, String rightSchemaJson, SparkSession sparkSession) {
        StructType leftSchema = (StructType)DataType$.MODULE$.fromJson(leftSchemaJson);
        StructType rightSchema = (StructType)DataType$.MODULE$.fromJson(rightSchemaJson);
        return this.toDf(spatialPairRDD, leftSchema, rightSchema, sparkSession);
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, StructType leftSchema, StructType rightSchema, SparkSession sparkSession) {
        RDD rowRdd = spatialPairRDD.rdd().map((Function1 & Serializable & scala.Serializable)pair -> {
            Seq leftRow = ((InternalRow)((Geometry)pair._1()).getUserData()).toSeq(leftSchema);
            Seq rightRow = ((InternalRow)((Geometry)pair._2()).getUserData()).toSeq(rightSchema);
            return InternalRow$.MODULE$.fromSeq((Seq)leftRow.$plus$plus((GenTraversableOnce)rightRow, Seq$.MODULE$.canBuildFrom()));
        }, ClassTag$.MODULE$.apply(InternalRow.class));
        return sparkSession.internalCreateDataFrame(rowRdd, new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rightSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))), sparkSession.internalCreateDataFrame$default$3());
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, SpatialRDD<Geometry> originalLeftSpatialRdd, SpatialRDD<Geometry> originalRightSpatialRdd, SparkSession sparkSession) {
        return this.toDf(spatialPairRDD, originalLeftSpatialRdd.schema, originalRightSpatialRdd.schema, sparkSession);
    }

    private StructuredAdapter$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

