/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialRDD;

import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.sedona.core.formatMapper.FormatMapper;
import org.apache.sedona.core.formatMapper.LineStringFormatMapper;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.locationtech.jts.geom.LineString;

public class LineStringRDD
extends SpatialRDD<LineString> {
    public LineStringRDD() {
    }

    public LineStringRDD(JavaRDD<LineString> rawSpatialRDD) {
        this.setRawSpatialRDD(rawSpatialRDD);
    }

    public LineStringRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter, boolean carryInputData) {
        this(sparkContext, InputLocation, startOffset, endOffset, splitter, carryInputData, null);
    }

    public LineStringRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData, Integer partitions) {
        this(sparkContext, InputLocation, null, null, splitter, carryInputData, partitions);
    }

    public LineStringRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData) {
        this(sparkContext, InputLocation, null, null, splitter, carryInputData);
    }

    public LineStringRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation, partitions.intValue()).mapPartitions(userSuppliedMapper));
    }

    public LineStringRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation).mapPartitions(userSuppliedMapper));
    }

    public LineStringRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter, boolean carryInputData, Integer partitions) {
        JavaRDD rawTextRDD;
        JavaRDD javaRDD = rawTextRDD = partitions != null ? sparkContext.textFile(InputLocation, partitions.intValue()) : sparkContext.textFile(InputLocation);
        if (startOffset != null && endOffset != null) {
            this.setRawSpatialRDD(rawTextRDD.mapPartitions((FlatMapFunction)new LineStringFormatMapper(startOffset, endOffset, splitter, carryInputData)));
        } else {
            this.setRawSpatialRDD(rawTextRDD.mapPartitions((FlatMapFunction)new LineStringFormatMapper(splitter, carryInputData)));
        }
        if (splitter.equals((Object)FileDataSplitter.GEOJSON)) {
            this.fieldNames = FormatMapper.readGeoJsonPropertyNames((String)rawTextRDD.take(1).get(0).toString());
        }
        this.analyze();
    }
}

