/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import io.github.resilience4j.decorators.Decorators;
import io.github.resilience4j.retry.Retry;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.governance.GovernanceConfiguration;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.core.governance.RetryContext;
import org.apache.servicecomb.governance.handler.RetryHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.swagger.invocation.Response;
import org.springframework.beans.factory.annotation.Autowired;

public class RetryFilter
extends AbstractFilter
implements ConsumerFilter,
EdgeFilter {
    private static final Object LOCK = new Object();
    private static volatile ScheduledExecutorService reactiveRetryPool;
    private final RetryHandler retryHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScheduledExecutorService getOrCreateRetryPool() {
        if (reactiveRetryPool == null) {
            Object object = LOCK;
            synchronized (object) {
                if (reactiveRetryPool == null) {
                    reactiveRetryPool = Executors.newScheduledThreadPool(2, new ThreadFactory(){
                        private final AtomicInteger count = new AtomicInteger(0);

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread thread = new Thread(r, "reactive-retry-pool-thread-" + this.count.getAndIncrement());
                            thread.setDaemon(true);
                            return thread;
                        }
                    });
                }
            }
        }
        return reactiveRetryPool;
    }

    @Autowired
    public RetryFilter(RetryHandler retryHandler) {
        this.retryHandler = retryHandler;
    }

    @Override
    public String getName() {
        return "retry";
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest(invocation);
        Retry retry = (Retry)this.retryHandler.getActuator(request);
        if (retry == null) {
            return nextNode.onFilter(invocation);
        }
        Supplier<CompletionStage<Response>> next = this.createBusinessCompletionStageSupplier(invocation, nextNode);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        dcs.withRetry(retry, RetryFilter.getOrCreateRetryPool());
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                future.complete((Response)r);
                return;
            }
            future.completeExceptionally((Throwable)e);
        });
        return future;
    }

    private Supplier<CompletionStage<Response>> createBusinessCompletionStageSupplier(Invocation invocation, FilterNode nextNode) {
        return () -> {
            RetryFilter.updateRetryStatus(invocation);
            return nextNode.onFilter(invocation);
        };
    }

    private static void updateRetryStatus(Invocation invocation) {
        if (invocation.getLocalContext("x-context-retry") != null) {
            if (invocation.getLocalContext("x-context-retry-loadbalance") != null && ((Boolean)invocation.getLocalContext("x-context-retry-loadbalance")).booleanValue()) {
                invocation.setEndpoint(null);
            }
            RetryContext retryContext = (RetryContext)invocation.getLocalContext("x-context-retry");
            retryContext.incrementRetry();
            return;
        }
        invocation.addLocalContext("x-context-retry", new RetryContext(GovernanceConfiguration.getRetrySameServer(invocation.getMicroserviceName())));
    }

    @Override
    public int getOrder() {
        return -1990;
    }
}

