/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.solution.basic.integration;

import com.google.common.eventbus.EventBus;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.provider.rest.common.RestSchema;
import org.apache.servicecomb.solution.basic.integration.MetricsEndpoint;

@RestSchema(schemaId="scb-metrics", schemaInterface=MetricsEndpoint.class)
public class MetricsEndpointImpl
implements MetricsInitializer,
MetricsEndpoint {
    private MeterRegistry meterRegistry;

    public void init(MeterRegistry meterRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public Map<String, Double> measure() {
        LinkedHashMap<String, Double> measurements = new LinkedHashMap<String, Double>();
        StringBuilder sb = new StringBuilder();
        for (Meter meter : this.meterRegistry.getMeters()) {
            meter.measure().forEach(measurement -> {
                String key = this.idToString(meter.getId(), (Measurement)measurement, sb);
                measurements.put(key, measurement.getValue());
            });
        }
        return measurements;
    }

    protected String idToString(Meter.Id id, Measurement measurement, StringBuilder sb) {
        sb.setLength(0);
        sb.append(id.getName()).append("(").append("statistic").append("=").append(measurement.getStatistic().name()).append(",");
        sb.append(StreamSupport.stream(id.getTags().spliterator(), false).map(this::tagToString).collect(Collectors.joining(",")));
        sb.append(')');
        return sb.toString();
    }

    private String tagToString(Tag tag) {
        return tag.getKey() + "=" + tag.getValue();
    }
}

