/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.OutputEx;
import io.protostuff.ProtobufOutputEx;
import io.protostuff.WireFormat;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldType;
import io.protostuff.runtime.FieldTypeUtils;
import java.io.IOException;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;

public abstract class FieldSchema<T> {
    protected final Field protoField;
    protected final String name;
    protected final int fieldNumber;
    protected final int tag;
    protected final int tagSize;
    protected final boolean packed;
    protected final JavaType javaType;
    protected final boolean primitive;

    public FieldSchema(Field protoField, JavaType javaType) {
        this.protoField = protoField;
        this.name = protoField.getName();
        this.fieldNumber = protoField.getTag();
        this.packed = ProtoUtils.isPacked(protoField);
        int wireType = this.packed && protoField.isRepeated() ? 2 : FieldTypeUtils.convert((FieldType)protoField.getType()).wireType;
        this.tag = WireFormat.makeTag((int)this.fieldNumber, (int)wireType);
        this.tagSize = ProtobufOutputEx.computeRawVarint32Size(this.tag);
        this.javaType = javaType;
        this.primitive = javaType.isPrimitive();
    }

    public int getFieldNumber() {
        return this.fieldNumber;
    }

    public Field getProtoField() {
        return this.protoField;
    }

    public int mergeFrom(InputEx input, T message) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public void getAndWriteTo(OutputEx output, T message) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputEx output, Object value) throws IOException {
        throw new UnsupportedOperationException();
    }
}

