/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.classreading.RecursiveAnnotationAttributesVisitor;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

final class AnnotationAttributesReadingVisitor
extends RecursiveAnnotationAttributesVisitor {
    private final MultiValueMap<String, AnnotationAttributes> attributesMap;
    private final Map<String, Set<String>> metaAnnotationMap;

    public AnnotationAttributesReadingVisitor(String annotationType, MultiValueMap<String, AnnotationAttributes> attributesMap, Map<String, Set<String>> metaAnnotationMap, ClassLoader classLoader) {
        super(annotationType, new AnnotationAttributes(annotationType, classLoader), classLoader);
        this.attributesMap = attributesMap;
        this.metaAnnotationMap = metaAnnotationMap;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        Class<? extends Annotation> annotationClass = this.attributes.annotationType();
        if (annotationClass != null) {
            List attributeList = (List)this.attributesMap.get(this.annotationType);
            if (attributeList == null) {
                this.attributesMap.add(this.annotationType, this.attributes);
            } else {
                attributeList.add(0, this.attributes);
            }
            LinkedHashSet<Annotation> visited = new LinkedHashSet<Annotation>();
            Object[] metaAnnotations = AnnotationUtils.getAnnotations(annotationClass);
            if (!ObjectUtils.isEmpty(metaAnnotations)) {
                for (Object metaAnnotation : metaAnnotations) {
                    if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)metaAnnotation)) continue;
                    this.recursivelyCollectMetaAnnotations(visited, (Annotation)metaAnnotation);
                }
            }
            if (this.metaAnnotationMap != null) {
                LinkedHashSet<String> metaAnnotationTypeNames = new LinkedHashSet<String>(visited.size());
                for (Annotation ann : visited) {
                    metaAnnotationTypeNames.add(ann.annotationType().getName());
                }
                this.metaAnnotationMap.put(annotationClass.getName(), metaAnnotationTypeNames);
            }
        }
    }

    private void recursivelyCollectMetaAnnotations(Set<Annotation> visited, Annotation annotation) {
        block5: {
            if (!AnnotationUtils.isInJavaLangAnnotationPackage(annotation) && visited.add(annotation)) {
                try {
                    if (Modifier.isPublic(annotation.annotationType().getModifiers())) {
                        Annotation[] annotationName = annotation.annotationType().getName();
                        this.attributesMap.add((String)annotationName, AnnotationUtils.getAnnotationAttributes(annotation, false, true));
                    }
                    for (Annotation metaMetaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.recursivelyCollectMetaAnnotations(visited, metaMetaAnnotation);
                    }
                }
                catch (Exception ex) {
                    if (!this.logger.isDebugEnabled()) break block5;
                    this.logger.debug((Object)("Failed to introspect meta-annotations on [" + annotation + "]: " + ex));
                }
            }
        }
    }
}

