/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.MultiException;
import org.apache.karaf.util.jaas.JaasHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.BundleStartLevel;

@Command(scope="bundle", name="install", description="Installs one or more bundles.")
@Service
public class Install
implements Action {
    @Argument(index=0, name="urls", description="Bundle URLs separated by whitespaces", required=true, multiValued=true)
    List<URI> urls;
    @Option(name="-s", aliases={"--start"}, description="Starts the bundles after installation", required=false, multiValued=false)
    boolean start;
    @Option(name="-l", aliases={"--start-level"}, description="Sets the start level of the bundles", required=false, multiValued=false)
    Integer level;
    @Option(name="--force", aliases={"-f"}, description="Forces the command to execute", required=false, multiValued=false)
    boolean force;
    @Reference
    Session session;
    @Reference
    BundleService bundleService;
    @Reference
    BundleContext bundleContext;

    public Object execute() throws Exception {
        if (this.level != null) {
            int sbsl = this.bundleService.getSystemBundleThreshold();
            if (this.level < sbsl && !JaasHelper.currentUserHasRole("systembundles")) {
                throw new IllegalArgumentException("Insufficient privileges");
            }
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (URI url : this.urls) {
            try {
                bundles.add(this.bundleContext.installBundle(url.toString(), null));
            }
            catch (Exception e) {
                exceptions.add(new Exception("Unable to install bundle " + url, e));
            }
        }
        if (this.level != null) {
            for (Bundle bundle : bundles) {
                try {
                    ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(this.level.intValue());
                }
                catch (Exception e) {
                    exceptions.add(new Exception("Unable to set bundle start level " + bundle.getLocation(), e));
                }
            }
        }
        if (this.start) {
            for (Bundle bundle : bundles) {
                try {
                    bundle.start();
                }
                catch (Exception e) {
                    exceptions.add(new Exception("Unable to start bundle " + bundle.getLocation(), e));
                }
            }
        }
        if (bundles.size() == 1) {
            System.out.println("Bundle ID: " + ((Bundle)bundles.get(0)).getBundleId());
        } else {
            StringBuffer sb = new StringBuffer("Bundle IDs: ");
            for (Bundle bundle : bundles) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(bundle.getBundleId());
            }
            System.out.println(sb);
        }
        MultiException.throwIf((String)"Error installing bundles", exceptions);
        return null;
    }
}

