/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.util.Map;
import org.iq80.leveldb.table.Block;
import org.iq80.leveldb.table.BlockIterator;
import org.iq80.leveldb.table.Table;
import org.iq80.leveldb.util.AbstractSeekingIterator;
import org.iq80.leveldb.util.Slice;

public final class TableIterator
extends AbstractSeekingIterator<Slice, Slice> {
    private final Table table;
    private final BlockIterator blockIterator;
    private BlockIterator current;

    public TableIterator(Table table, BlockIterator blockIterator) {
        this.table = table;
        this.blockIterator = blockIterator;
        this.current = null;
    }

    @Override
    protected void seekToFirstInternal() {
        this.blockIterator.seekToFirst();
        this.current = null;
    }

    @Override
    protected void seekInternal(Slice targetKey) {
        this.blockIterator.seek(targetKey);
        if (this.blockIterator.hasNext()) {
            this.current = this.getNextBlock();
            this.current.seek(targetKey);
        } else {
            this.current = null;
        }
    }

    @Override
    protected Map.Entry<Slice, Slice> getNextElement() {
        boolean currentHasNext = false;
        while (true) {
            if (this.current != null) {
                currentHasNext = this.current.hasNext();
            }
            if (currentHasNext || !this.blockIterator.hasNext()) break;
            this.current = this.getNextBlock();
        }
        if (currentHasNext) {
            return this.current.next();
        }
        this.current = null;
        return null;
    }

    private BlockIterator getNextBlock() {
        Slice blockHandle = this.blockIterator.next().getValue();
        Block dataBlock = this.table.openBlock(blockHandle);
        return dataBlock.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConcatenatingIterator");
        sb.append("{blockIterator=").append(this.blockIterator);
        sb.append(", current=").append(this.current);
        sb.append('}');
        return sb.toString();
    }
}

