/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="dataformat,transformation,security", title="Crypto (Java Cryptographic Extension)")
@XmlRootElement(name="crypto")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CryptoDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(defaultValue="DES/CBC/PKCS5Padding")
    private String algorithm;
    @XmlAttribute
    private String cryptoProvider;
    @XmlAttribute
    private String keyRef;
    @XmlAttribute
    private String initVectorRef;
    @XmlAttribute
    private String algorithmParameterRef;
    @XmlAttribute
    private Integer buffersize;
    @XmlAttribute
    @Metadata(defaultValue="HmacSHA1")
    private String macAlgorithm = "HmacSHA1";
    @XmlAttribute
    private Boolean shouldAppendHMAC;
    @XmlAttribute
    private Boolean inline;

    public CryptoDataFormat() {
        super("crypto");
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        DataFormat cryptoFormat = super.createDataFormat(routeContext);
        if (ObjectHelper.isNotEmpty(this.keyRef)) {
            Key key = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.keyRef, Key.class);
            this.setProperty(routeContext.getCamelContext(), cryptoFormat, "key", key);
        }
        if (ObjectHelper.isNotEmpty(this.algorithmParameterRef)) {
            AlgorithmParameterSpec spec = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.algorithmParameterRef, AlgorithmParameterSpec.class);
            this.setProperty(routeContext.getCamelContext(), cryptoFormat, "AlgorithmParameterSpec", spec);
        }
        if (ObjectHelper.isNotEmpty(this.initVectorRef)) {
            byte[] iv = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.initVectorRef, byte[].class);
            this.setProperty(routeContext.getCamelContext(), cryptoFormat, "InitializationVector", iv);
        }
        return cryptoFormat;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        Boolean answer = ObjectHelper.toBoolean(this.shouldAppendHMAC);
        if (answer != null && !answer.booleanValue()) {
            this.setProperty(camelContext, dataFormat, "shouldAppendHMAC", Boolean.FALSE);
        } else {
            this.setProperty(camelContext, dataFormat, "shouldAppendHMAC", Boolean.TRUE);
        }
        answer = ObjectHelper.toBoolean(this.inline);
        if (answer != null && answer.booleanValue()) {
            this.setProperty(camelContext, dataFormat, "shouldInlineInitializationVector", Boolean.TRUE);
        } else {
            this.setProperty(camelContext, dataFormat, "shouldInlineInitializationVector", Boolean.FALSE);
        }
        if (this.algorithm != null) {
            this.setProperty(camelContext, dataFormat, "algorithm", this.algorithm);
        }
        if (this.cryptoProvider != null) {
            this.setProperty(camelContext, dataFormat, "cryptoProvider", this.cryptoProvider);
        }
        if (this.macAlgorithm != null) {
            this.setProperty(camelContext, dataFormat, "macAlgorithm", this.macAlgorithm);
        }
        if (this.buffersize != null) {
            this.setProperty(camelContext, dataFormat, "buffersize", this.buffersize);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(String cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public String getKeyRef() {
        return this.keyRef;
    }

    public void setKeyRef(String keyRef) {
        this.keyRef = keyRef;
    }

    public String getInitVectorRef() {
        return this.initVectorRef;
    }

    public void setInitVectorRef(String initVectorRef) {
        this.initVectorRef = initVectorRef;
    }

    public String getAlgorithmParameterRef() {
        return this.algorithmParameterRef;
    }

    public void setAlgorithmParameterRef(String algorithmParameterRef) {
        this.algorithmParameterRef = algorithmParameterRef;
    }

    public Integer getBuffersize() {
        return this.buffersize;
    }

    public void setBuffersize(Integer buffersize) {
        this.buffersize = buffersize;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public Boolean getShouldAppendHMAC() {
        return this.shouldAppendHMAC;
    }

    public void setShouldAppendHMAC(Boolean shouldAppendHMAC) {
        this.shouldAppendHMAC = shouldAppendHMAC;
    }

    public Boolean getInline() {
        return this.inline;
    }

    public void setInline(Boolean inline) {
        this.inline = inline;
    }
}

