/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.persistence;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.attachment.AttachmentSerializer;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStoreException;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;

public final class PersistenceUtils {
    private static PersistenceUtils instance;
    private JAXBContext context;

    private PersistenceUtils() {
    }

    public static PersistenceUtils getInstance() {
        if (null == instance) {
            instance = new PersistenceUtils();
        }
        return instance;
    }

    public SequenceAcknowledgement deserialiseAcknowledgment(InputStream is) {
        Object obj = null;
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((InputStream)is);
        try {
            obj = this.getContext().createUnmarshaller().unmarshal(reader);
            if (obj instanceof JAXBElement) {
                JAXBElement el = (JAXBElement)obj;
                obj = el.getValue();
            }
        }
        catch (JAXBException ex) {
            throw new RMStoreException(ex);
        }
        finally {
            try {
                StaxUtils.close((XMLStreamReader)reader);
                is.close();
            }
            catch (Throwable throwable) {}
        }
        return (SequenceAcknowledgement)obj;
    }

    public InputStream serialiseAcknowledgment(SequenceAcknowledgement ack) {
        LoadingByteArrayOutputStream bos = new LoadingByteArrayOutputStream();
        try {
            this.getContext().createMarshaller().marshal((Object)ack, (OutputStream)bos);
        }
        catch (JAXBException ex) {
            throw new RMStoreException(ex);
        }
        return bos.createInputStream();
    }

    private JAXBContext getContext() throws JAXBException {
        if (null == this.context) {
            this.context = JAXBContext.newInstance((String)PackageUtils.getPackageName(SequenceAcknowledgement.class), (ClassLoader)this.getClass().getClassLoader());
        }
        return this.context;
    }

    public static void encodeRMContent(RMMessage rmmsg, Message msg, InputStream msgContent) throws IOException {
        CachedOutputStream cos = new CachedOutputStream();
        if (msg.getAttachments() == null) {
            rmmsg.setContentType((String)msg.get((Object)"Content-Type"));
            IOUtils.copyAndCloseInput((InputStream)msgContent, (OutputStream)cos);
            cos.flush();
            rmmsg.setContent(cos);
        } else {
            MessageImpl msgImpl1 = new MessageImpl();
            msgImpl1.setContent(OutputStream.class, (Object)cos);
            msgImpl1.setAttachments(msg.getAttachments());
            msgImpl1.put("Content-Type", (Object)((String)msg.get((Object)"Content-Type")));
            msgImpl1.setContent(InputStream.class, (Object)msgContent);
            AttachmentSerializer serializer = new AttachmentSerializer((Message)msgImpl1);
            serializer.setXop(false);
            serializer.writeProlog();
            IOUtils.copyAndCloseInput((InputStream)msgContent, (OutputStream)cos);
            cos.flush();
            serializer.writeAttachments();
            rmmsg.setContentType((String)msgImpl1.get((Object)"Content-Type"));
            rmmsg.setContent(cos);
        }
    }

    public static void decodeRMContent(RMMessage rmmsg, Message msg) throws IOException {
        String contentType = rmmsg.getContentType();
        final CachedOutputStream cos = rmmsg.getContent();
        if (null != contentType && contentType.startsWith("multipart/related")) {
            final InputStream is = cos.getInputStream();
            msg.put((Object)"Content-Type", (Object)contentType);
            msg.setContent(InputStream.class, (Object)is);
            AttachmentDeserializer ad = new AttachmentDeserializer(msg);
            ad.initializeAttachments();
            CachedOutputStream cosSoap = new CachedOutputStream();
            IOUtils.copy((InputStream)((InputStream)msg.getContent(InputStream.class)), (OutputStream)cosSoap);
            cosSoap.flush();
            msg.put((Object)"org.apache.cxf.ws.rm.content", (Object)cosSoap);
            msg.put((Object)"org.apache.cxf.ws.rm.attachment.closeable", (Object)new Closeable(){

                @Override
                public void close() throws IOException {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        cos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        } else {
            msg.put((Object)"org.apache.cxf.ws.rm.content", (Object)cos);
        }
    }
}

