/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.common.dto;

import java.util.Objects;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataType;
import org.apache.shenyu.register.common.type.DataTypeParent;

public class URIRegisterDTO
implements DataTypeParent {
    private String protocol;
    private String appName;
    private String contextPath;
    private String rpcType;
    private String host;
    private Integer port;
    private EventType eventType;
    private String namespaceId;
    private String instanceInfo;

    public URIRegisterDTO(String protocol, String appName, String contextPath, String rpcType, String host, Integer port, EventType eventType, String namespaceId, String instanceInfo) {
        this.protocol = protocol;
        this.appName = appName;
        this.contextPath = contextPath;
        this.rpcType = rpcType;
        this.host = host;
        this.port = port;
        this.eventType = eventType;
        this.namespaceId = namespaceId;
        this.instanceInfo = instanceInfo;
    }

    public URIRegisterDTO() {
    }

    private URIRegisterDTO(Builder builder) {
        this.protocol = builder.protocol;
        this.appName = builder.appName;
        this.contextPath = builder.contextPath;
        this.rpcType = builder.rpcType;
        this.host = builder.host;
        this.port = builder.port;
        this.eventType = builder.eventType;
        this.namespaceId = builder.namespaceId;
        this.instanceInfo = builder.instanceInfo;
    }

    public static URIRegisterDTO transForm(MetaDataRegisterDTO metaDataRegisterDTO) {
        return URIRegisterDTO.builder().appName(metaDataRegisterDTO.getAppName()).contextPath(metaDataRegisterDTO.getContextPath()).rpcType(metaDataRegisterDTO.getRpcType()).host(metaDataRegisterDTO.getHost()).port(metaDataRegisterDTO.getPort()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public DataType getType() {
        return DataType.URI;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getRpcType() {
        return this.rpcType;
    }

    public void setRpcType(String rpcType) {
        this.rpcType = rpcType;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getInstanceInfo() {
        return this.instanceInfo;
    }

    public void setInstanceInfo(String instanceInfo) {
        this.instanceInfo = instanceInfo;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return Boolean.TRUE;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return Boolean.FALSE;
        }
        URIRegisterDTO that = (URIRegisterDTO)o;
        return Objects.equals(this.getAppName(), that.getAppName()) && Objects.equals(this.getProtocol(), that.getProtocol()) && Objects.equals(this.getContextPath(), that.getContextPath()) && Objects.equals(this.getRpcType(), that.getRpcType()) && Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getPort(), that.getPort()) && this.getEventType() == that.getEventType() && Objects.equals(this.getNamespaceId(), that.getNamespaceId()) && Objects.equals(this.getInstanceInfo(), that.getInstanceInfo());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProtocol(), this.getAppName(), this.getContextPath(), this.getRpcType(), this.getHost(), this.getPort(), this.getEventType(), this.getNamespaceId(), this.getInstanceInfo()});
    }

    public String toString() {
        return "URIRegisterDTO{protocol='" + this.protocol + "', appName='" + this.appName + "', contextPath='" + this.contextPath + "', rpcType='" + this.rpcType + "', host='" + this.host + "', port=" + this.port + ", eventType=" + this.eventType + ", namespaceId=" + this.namespaceId + ", instanceInfo=" + this.instanceInfo + "}";
    }

    public static final class Builder {
        private String protocol;
        private String appName;
        private String contextPath;
        private String rpcType;
        private String host;
        private Integer port;
        private EventType eventType;
        private String namespaceId;
        private String instanceInfo;

        private Builder() {
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder rpcType(String rpcType) {
            this.rpcType = rpcType;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder eventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public Builder instanceInfo(String instanceInfo) {
            this.instanceInfo = instanceInfo;
            return this;
        }

        public URIRegisterDTO build() {
            return new URIRegisterDTO(this);
        }
    }
}

