/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.exception;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.ServerCodes;

public class ServerErrorResponseException
extends PolarisException {
    private final int serverCode;

    public static ServerErrorResponseException build(int serverCode, String errorInfo) {
        if (serverCode == 400202 || serverCode == 400301) {
            return new ServerErrorResponseException(ErrorCode.SERVICE_NOT_FOUND, serverCode, errorInfo);
        }
        int httpServerCode = ServerCodes.toHttpCode(serverCode);
        if (httpServerCode == 500) {
            return new ServerErrorResponseException(ErrorCode.SERVER_EXCEPTION, serverCode, errorInfo);
        }
        return new ServerErrorResponseException(ErrorCode.SERVER_USER_ERROR, serverCode, errorInfo);
    }

    private ServerErrorResponseException(ErrorCode code, int serverCode, String errorInfo) {
        super(code, errorInfo);
        this.serverCode = serverCode;
    }

    public int getServerCode() {
        return this.serverCode;
    }
}

