/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.flow;

import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.client.pojo.ServicesByProto;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResourcesResponse {
    private final Map<ServiceEventKey, Services> servicesMap = new ConcurrentHashMap<ServiceEventKey, Services>();
    private final Map<ServiceEventKey, ServiceInstances> instancesMap = new ConcurrentHashMap<ServiceEventKey, ServiceInstances>();
    private final Map<ServiceEventKey, ServiceRule> rules = new ConcurrentHashMap<ServiceEventKey, ServiceRule>();
    private final Map<ServiceEventKey, Throwable> errors = new ConcurrentHashMap<ServiceEventKey, Throwable>();

    public void addServiceInstances(ServiceEventKey svcEventKey, ServiceInstances instances) {
        this.instancesMap.put(svcEventKey, instances);
    }

    public void addServices(ServiceEventKey svcEventKey, Services services) {
        this.servicesMap.put(svcEventKey, services);
    }

    public ServiceInstances getServiceInstances(ServiceEventKey svcEventKey) {
        ServiceInstances serviceInstances = this.instancesMap.get(svcEventKey);
        if (null == serviceInstances) {
            serviceInstances = ServiceInstancesByProto.EMPTY_INSTANCES;
        }
        return serviceInstances;
    }

    public Map<ServiceEventKey, ServiceInstances> getAllServiceInstances() {
        return this.instancesMap;
    }

    public Map<ServiceEventKey, ServiceRule> getAllServiceRules() {
        return this.rules;
    }

    public void addServiceRule(ServiceEventKey svcEventKey, ServiceRule rule) {
        this.rules.put(svcEventKey, rule);
    }

    public ServiceRule getServiceRule(ServiceEventKey svcEventKey) {
        ServiceRule serviceRule = this.rules.get(svcEventKey);
        if (serviceRule == null) {
            serviceRule = ServiceRuleByProto.EMPTY_SERVICE_RULE;
        }
        return serviceRule;
    }

    public Services getServices(ServiceEventKey svcEventKey) {
        Services services = this.servicesMap.get(svcEventKey);
        if (services == null) {
            services = ServicesByProto.EMPTY_SERVICES;
        }
        return services;
    }

    public void addError(ServiceEventKey svcEventKey, Throwable error) {
        this.errors.put(svcEventKey, error);
    }

    public Map<ServiceEventKey, Throwable> getErrors() {
        return this.errors;
    }
}

