/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.expression.Expression;
import org.springframework.integration.core.GenericTransformer;
import org.springframework.integration.dsl.ConsumerEndpointSpec;
import org.springframework.integration.dsl.MessageProcessorSpec;
import org.springframework.integration.handler.BeanNameMessageProcessor;
import org.springframework.integration.handler.LambdaMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.transformer.ExpressionEvaluatingTransformer;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.MethodInvokingTransformer;
import org.springframework.integration.transformer.Transformer;
import org.springframework.integration.util.ClassUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TransformerEndpointSpec
extends ConsumerEndpointSpec<TransformerEndpointSpec, MessageTransformingHandler> {
    private final AtomicBoolean transformerSet = new AtomicBoolean();
    private Expression expression;
    private Object ref;
    private String refName;
    @Nullable
    private String method;
    private GenericTransformer<?, ?> transformer;
    @Nullable
    private Class<?> expectedType;
    private MessageProcessorSpec<?> processor;

    protected TransformerEndpointSpec() {
        super(new MessageTransformingHandler());
    }

    public TransformerEndpointSpec expression(String expression) {
        return this.expression(PARSER.parseExpression(expression));
    }

    public TransformerEndpointSpec expression(Expression expression) {
        this.assertTransformerSet();
        this.expression = expression;
        return this;
    }

    public TransformerEndpointSpec ref(Object ref) {
        this.assertTransformerSet();
        this.ref = ref;
        return this;
    }

    public TransformerEndpointSpec refName(String refName) {
        this.assertTransformerSet();
        this.refName = refName;
        return this;
    }

    public TransformerEndpointSpec method(@Nullable String method) {
        this.method = method;
        return this;
    }

    public <P, T> TransformerEndpointSpec transformer(GenericTransformer<P, T> transformer2) {
        this.assertTransformerSet();
        this.transformer = transformer2;
        return this;
    }

    public <P> TransformerEndpointSpec expectedType(@Nullable Class<P> expectedType) {
        this.expectedType = expectedType;
        return this;
    }

    public TransformerEndpointSpec processor(MessageProcessorSpec<?> processor) {
        this.assertTransformerSet();
        this.processor = processor;
        return this;
    }

    private void assertTransformerSet() {
        Assert.isTrue((boolean)this.transformerSet.compareAndSet(false, true), this::assertMessage);
    }

    private String assertMessage() {
        String currentTransformerValue = null;
        if (this.expression != null) {
            currentTransformerValue = "'expression'=" + this.expression;
        } else if (this.ref != null) {
            currentTransformerValue = "'ref'=" + this.ref;
        } else if (this.refName != null) {
            currentTransformerValue = "'refName'=" + this.refName;
        } else if (this.transformer != null) {
            currentTransformerValue = "'transformer'=" + this.transformer;
        } else if (this.processor != null) {
            currentTransformerValue = "'processor'=" + this.processor;
        }
        return "Only one of the 'expression', 'ref', 'refName', 'processor' or 'transformer' can be set. Current one is " + currentTransformerValue;
    }

    @Override
    public Map<Object, String> getComponentsToRegister() {
        Transformer transformer2;
        if (this.expression != null) {
            transformer2 = new ExpressionEvaluatingTransformer(this.expression);
        } else if (this.ref != null) {
            transformer2 = this.method != null ? new MethodInvokingTransformer(this.ref, this.method) : new MethodInvokingTransformer(this.ref);
        } else if (this.refName != null) {
            transformer2 = new MethodInvokingTransformer((Object)new BeanNameMessageProcessor(this.refName, this.method));
        } else if (this.processor != null) {
            MessageProcessor targetProcessor = (MessageProcessor)this.processor.getObject();
            this.componentsToRegister.put(targetProcessor, null);
            transformer2 = new MethodInvokingTransformer((Object)targetProcessor);
        } else if (this.transformer != null) {
            transformer2 = this.wrapToTransformerIfAny();
        } else {
            throw new IllegalStateException("One of the 'expression', 'ref', 'refName', 'processor' or 'transformer' must be provided.");
        }
        ((MessageTransformingHandler)this.handler).setTransformer(transformer2);
        this.componentsToRegister.put(transformer2, null);
        return super.getComponentsToRegister();
    }

    private Transformer wrapToTransformerIfAny() {
        return this.transformer instanceof Transformer ? (Transformer)this.transformer : (ClassUtils.isLambda(this.transformer) ? new MethodInvokingTransformer((Object)new LambdaMessageProcessor(this.transformer, this.expectedType)) : new MethodInvokingTransformer(this.transformer, ClassUtils.TRANSFORMER_TRANSFORM_METHOD));
    }
}

